/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@Implements(value=SQLiteProgram.class)
public abstract class ShadowSQLiteProgram {
    @RealObject
    SQLiteProgram realSQLiteProgram;
    protected SQLiteDatabase mDatabase;
    Connection connection;
    PreparedStatement actualDBstatement;

    public void init(SQLiteDatabase db, String sql) {
        this.mDatabase = db;
        this.connection = Robolectric.shadowOf(db).getConnection();
        try {
            this.actualDBstatement = this.connection.prepareStatement(sql, 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.compile(sql, false);
    }

    @Implementation
    public void compile(String sql, boolean forceCompilation) {
    }

    @Implementation
    public void bindNull(int index) {
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.setNull(index, 0);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void bindLong(int index, long value) {
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.setLong(index, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkDatabaseIsOpen() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
    }

    public PreparedStatement getStatement() {
        return this.actualDBstatement;
    }

    @Implementation
    public void bindDouble(int index, double value) {
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.setDouble(index, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.setString(index, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.setBytes(index, value);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void clearBindings() {
        this.checkDatabaseIsOpen();
        try {
            this.actualDBstatement.clearParameters();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

