/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.sqlite.SQLiteQueryBuilder;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.util.Join;

@Implements(value=SQLiteQueryBuilder.class)
public class ShadowSQLiteQueryBuilder {
    @Implementation
    public static String buildQueryString(boolean distinct, String tables, String[] columns, String where, String groupBy, String having, String orderBy, String limit) {
        StringBuilder sb = new StringBuilder("SELECT ");
        if (distinct) {
            sb.append("DISTINCT ");
        }
        if (columns != null) {
            sb.append(Join.join(", ", columns));
        } else {
            sb.append("*");
        }
        sb.append(" FROM ");
        sb.append(tables);
        ShadowSQLiteQueryBuilder.conditionallyAppend(sb, " WHERE ", where);
        ShadowSQLiteQueryBuilder.conditionallyAppend(sb, " GROUP BY ", groupBy);
        ShadowSQLiteQueryBuilder.conditionallyAppend(sb, " HAVING ", having);
        ShadowSQLiteQueryBuilder.conditionallyAppend(sb, " ORDER BY ", orderBy);
        ShadowSQLiteQueryBuilder.conditionallyAppend(sb, " LIMIT ", limit);
        return sb.toString();
    }

    private static void conditionallyAppend(StringBuilder sb, String keyword, String value) {
        if (value != null) {
            sb.append(keyword);
            sb.append(value);
        }
    }
}

