/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteStatement;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowSQLiteProgram;
import java.sql.ResultSet;
import java.sql.SQLException;

@Implements(value=SQLiteStatement.class)
public class ShadowSQLiteStatement
extends ShadowSQLiteProgram {
    String mSql;

    @Override
    public void init(SQLiteDatabase db, String sql) {
        super.init(db, sql);
        this.mSql = sql;
    }

    @Implementation
    public void execute() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        try {
            this.actualDBstatement.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public long executeInsert() {
        try {
            this.actualDBstatement.executeUpdate();
            ResultSet resultSet = this.actualDBstatement.getGeneratedKeys();
            if (resultSet.next()) {
                return resultSet.getLong(1);
            }
            throw new RuntimeException("Could not retrive generatedKeys");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public long simpleQueryForLong() {
        try {
            ResultSet rs = this.actualDBstatement.executeQuery();
            rs.next();
            return rs.getLong(1);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public String simpleQueryForString() {
        try {
            ResultSet rs = this.actualDBstatement.executeQuery();
            rs.next();
            return rs.getString(1);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    private void handleException(SQLException e) {
        if (e.getMessage().contains("No data is available")) {
            throw new SQLiteDoneException("No data is available");
        }
        if (e.getMessage().contains("ResultSet closed")) {
            throw new SQLiteDoneException("ResultSet closed,(probably, no data available)");
        }
    }
}

