/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Application;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.ServiceConnection;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowApplication;
import com.xtremelabs.robolectric.shadows.ShadowContextWrapper;

@Implements(value=Service.class)
public class ShadowService
extends ShadowContextWrapper {
    @RealObject
    Service realService;
    private Notification lastForegroundNotification;
    private boolean selfStopped = false;
    private boolean unbindServiceShouldThrowIllegalArgument = false;
    private boolean foregroundStopped;
    private boolean notificationShouldRemoved;

    @Implementation
    public final Application getApplication() {
        return Robolectric.application;
    }

    @Override
    @Implementation
    public Context getApplicationContext() {
        return Robolectric.application;
    }

    @Implementation
    public void onDestroy() {
        this.assertNoBroadcastListenersRegistered();
    }

    @Implementation
    public void unbindService(ServiceConnection conn) {
        if (this.unbindServiceShouldThrowIllegalArgument) {
            throw new IllegalArgumentException();
        }
    }

    @Implementation
    public void stopSelf() {
        this.selfStopped = true;
    }

    public void setUnbindServiceShouldThrowIllegalArgument(boolean flag) {
        this.unbindServiceShouldThrowIllegalArgument = flag;
    }

    @Implementation
    public final void startForeground(int id, Notification notification) {
        this.lastForegroundNotification = notification;
    }

    @Implementation
    public void stopForeground(boolean removeNotification) {
        this.foregroundStopped = true;
        this.notificationShouldRemoved = removeNotification;
    }

    public Notification getLastForegroundNotification() {
        return this.lastForegroundNotification;
    }

    public void assertNoBroadcastListenersRegistered() {
        ((ShadowApplication)Robolectric.shadowOf(this.getApplicationContext())).assertNoBroadcastListenersRegistered((Context)this.realService, "Service");
    }

    public boolean isStoppedBySelf() {
        return this.selfStopped;
    }

    public boolean isForegroundStopped() {
        return this.foregroundStopped;
    }

    public boolean getNotificationShouldRemoved() {
        return this.notificationShouldRemoved;
    }
}

