/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.ContentResolver;
import android.provider.Settings;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

@Implements(value=Settings.class)
public class ShadowSettings {
    public static void setAirplaneMode(boolean isAirplaneMode) {
        Settings.System.putInt((ContentResolver)Robolectric.application.getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
    }

    public static void setWifiOn(boolean isOn) {
        Settings.Secure.putInt((ContentResolver)Robolectric.application.getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
    }

    public static void set24HourTimeFormat(boolean use24HourTimeFormat) {
        Settings.System.putInt((ContentResolver)Robolectric.application.getContentResolver(), (String)"time_12_24", (int)(use24HourTimeFormat ? 24 : 12));
    }

    @Implements(value=Settings.Secure.class)
    public static class ShadowSecure
    extends SettingsImpl {
    }

    @Implements(value=Settings.System.class)
    public static class ShadowSystem
    extends SettingsImpl {
    }

    @Implements(value=Settings.class)
    private static class SettingsImpl {
        private static final WeakHashMap<ContentResolver, Map<String, Object>> dataMap = new WeakHashMap();

        private SettingsImpl() {
        }

        @Implementation
        public static boolean putInt(ContentResolver cr, String name, int value) {
            SettingsImpl.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static int getInt(ContentResolver cr, String name, int def) {
            if (SettingsImpl.get(cr).get(name) instanceof Integer) {
                return (Integer)SettingsImpl.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        public static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (SettingsImpl.get(cr).get(name) instanceof Integer) {
                return (Integer)SettingsImpl.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        public static boolean putString(ContentResolver cr, String name, String value) {
            SettingsImpl.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static String getString(ContentResolver cr, String name) {
            if (SettingsImpl.get(cr).get(name) instanceof String) {
                return (String)SettingsImpl.get(cr).get(name);
            }
            return null;
        }

        @Implementation
        public static boolean putLong(ContentResolver cr, String name, long value) {
            SettingsImpl.get(cr).put(name, value);
            return true;
        }

        @Implementation
        public static long getLong(ContentResolver cr, String name, long def) {
            if (SettingsImpl.get(cr).get(name) instanceof Long) {
                return (Long)SettingsImpl.get(cr).get(name);
            }
            return def;
        }

        @Implementation
        public static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (SettingsImpl.get(cr).get(name) instanceof Long) {
                return (Long)SettingsImpl.get(cr).get(name);
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        public static boolean putFloat(ContentResolver cr, String name, float value) {
            SettingsImpl.get(cr).put(name, Float.valueOf(value));
            return true;
        }

        @Implementation
        public static float getFloat(ContentResolver cr, String name, float def) {
            if (SettingsImpl.get(cr).get(name) instanceof Float) {
                return ((Float)SettingsImpl.get(cr).get(name)).floatValue();
            }
            return def;
        }

        @Implementation
        public static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if (SettingsImpl.get(cr).get(name) instanceof Float) {
                return ((Float)SettingsImpl.get(cr).get(name)).floatValue();
            }
            throw new Settings.SettingNotFoundException(name);
        }

        @Implementation
        private static Map<String, Object> get(ContentResolver cr) {
            Map<String, Object> map = dataMap.get(cr);
            if (map == null) {
                map = new HashMap<String, Object>();
                dataMap.put(cr, map);
            }
            return map;
        }
    }
}

