/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowDrawable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Implements(value=StateListDrawable.class)
public class ShadowStateListDrawable
extends ShadowDrawable {
    private Map<Integer, Integer> stateToResource;
    private Map<List<Integer>, Drawable> stateToDrawable;

    public void __constructor__() {
        this.stateToResource = new HashMap<Integer, Integer>();
        this.stateToDrawable = new HashMap<List<Integer>, Drawable>();
    }

    public void addState(int stateId, int resId) {
        this.stateToResource.put(stateId, resId);
    }

    public int getResourceIdForState(int stateId) {
        return this.stateToResource.get(stateId);
    }

    @Implementation
    public void addState(int[] stateSet, Drawable drawable) {
        this.stateToDrawable.put(this.createStateList(stateSet), drawable);
    }

    public Drawable getDrawableForState(int[] stateSet) {
        return this.stateToDrawable.get(this.createStateList(stateSet));
    }

    private List<Integer> createStateList(int[] stateSet) {
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (stateSet == StateSet.WILD_CARD) {
            stateList.add(-1);
        } else {
            for (int state : stateSet) {
                stateList.add(state);
            }
        }
        return stateList;
    }
}

