/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.SyncResult;
import android.content.SyncStats;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.lang.reflect.Field;

@Implements(value=SyncResult.class)
public class ShadowSyncResult {
    @RealObject
    private SyncResult result;

    public void __constructor__() {
        try {
            Field f = SyncResult.class.getDeclaredField("stats");
            f.setAccessible(true);
            f.set(this.result, new SyncStats());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public boolean hasSoftError() {
        return this.result.syncAlreadyInProgress || this.result.stats.numIoExceptions > 0L;
    }

    @Implementation
    public boolean hasHardError() {
        return this.result.stats.numParseExceptions > 0L || this.result.stats.numConflictDetectedExceptions > 0L || this.result.stats.numAuthExceptions > 0L || this.result.tooManyDeletions || this.result.tooManyRetries || this.result.databaseError;
    }

    @Implementation
    public boolean hasError() {
        return this.hasSoftError() || this.hasHardError();
    }

    @Implementation
    public boolean madeSomeProgress() {
        return this.result.stats.numDeletes > 0L && !this.result.tooManyDeletions || this.result.stats.numInserts > 0L || this.result.stats.numUpdates > 0L;
    }

    @Implementation
    public void clear() {
        if (this.result.syncAlreadyInProgress) {
            throw new UnsupportedOperationException("you are not allowed to clear the ALREADY_IN_PROGRESS SyncStats");
        }
        this.result.tooManyDeletions = false;
        this.result.tooManyRetries = false;
        this.result.databaseError = false;
        this.result.fullSyncRequested = false;
        this.result.partialSyncUnavailable = false;
        this.result.moreRecordsToGet = false;
        this.result.delayUntil = 0L;
        this.result.stats.clear();
    }

    @Implements(value=SyncStats.class)
    public static class ShadowSyncStats {
        @RealObject
        private SyncStats stats;

        @Implementation
        public void clear() {
            this.stats.numAuthExceptions = 0L;
            this.stats.numIoExceptions = 0L;
            this.stats.numParseExceptions = 0L;
            this.stats.numConflictDetectedExceptions = 0L;
            this.stats.numInserts = 0L;
            this.stats.numUpdates = 0L;
            this.stats.numDeletes = 0L;
            this.stats.numEntries = 0L;
            this.stats.numSkippedEntries = 0L;
        }
    }
}

