/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.app.Activity;
import android.view.View;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowFrameLayout;
import com.xtremelabs.robolectric.shadows.ShadowTabSpec;
import java.util.ArrayList;
import java.util.List;

@Implements(value=TabHost.class)
public class ShadowTabHost
extends ShadowFrameLayout {
    private List<TabHost.TabSpec> tabSpecs = new ArrayList<TabHost.TabSpec>();
    private TabHost.OnTabChangeListener listener;
    private int currentTab = -1;
    @RealObject
    TabHost realObject;

    @Implementation
    public TabHost.TabSpec newTabSpec(String tag) {
        TabHost.TabSpec realTabSpec = Robolectric.newInstanceOf(TabHost.TabSpec.class);
        Robolectric.shadowOf(realTabSpec).setTag(tag);
        return realTabSpec;
    }

    @Implementation
    public void addTab(TabHost.TabSpec tabSpec) {
        this.tabSpecs.add(tabSpec);
        View indicatorAsView = Robolectric.shadowOf(tabSpec).getIndicatorAsView();
        if (indicatorAsView != null) {
            this.realObject.addView(indicatorAsView);
        }
    }

    @Implementation
    public void setCurrentTab(int index) {
        this.currentTab = index;
        if (this.listener != null) {
            this.listener.onTabChanged(this.getCurrentTabTag());
        }
    }

    @Implementation
    public void setCurrentTabByTag(String tag) {
        for (int x = 0; x < this.tabSpecs.size(); ++x) {
            TabHost.TabSpec tabSpec = this.tabSpecs.get(x);
            if (!tabSpec.getTag().equals(tag)) continue;
            this.currentTab = x;
        }
        if (this.listener != null) {
            this.listener.onTabChanged(this.getCurrentTabTag());
        }
    }

    @Implementation
    public int getCurrentTab() {
        if (this.currentTab == -1 && this.tabSpecs.size() > 0) {
            this.currentTab = 0;
        }
        return this.currentTab;
    }

    public TabHost.TabSpec getCurrentTabSpec() {
        return this.tabSpecs.get(this.getCurrentTab());
    }

    @Implementation
    public String getCurrentTabTag() {
        int i = this.getCurrentTab();
        if (i >= 0 && i < this.tabSpecs.size()) {
            return this.tabSpecs.get(i).getTag();
        }
        return null;
    }

    @Implementation
    public void setOnTabChangedListener(TabHost.OnTabChangeListener listener) {
        this.listener = listener;
    }

    @Implementation
    public View getCurrentView() {
        ShadowTabSpec ts = Robolectric.shadowOf(this.getCurrentTabSpec());
        View v = ts.getContentView();
        if (v == null) {
            int viewId = ts.getContentViewId();
            if (this.getContext() instanceof Activity) {
                v = ((Activity)this.getContext()).findViewById(viewId);
            } else {
                return null;
            }
        }
        return v;
    }

    @Implementation
    public TabWidget getTabWidget() {
        if (this.context instanceof Activity) {
            return (TabWidget)((Activity)this.context).findViewById(16908307);
        }
        return null;
    }

    public TabHost.TabSpec getSpecByTag(String tag) {
        for (TabHost.TabSpec tabSpec : this.tabSpecs) {
            if (!tag.equals(tabSpec.getTag())) continue;
            return tabSpec;
        }
        return null;
    }
}

