/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.text.method.TransformationMethod;
import android.text.style.URLSpan;
import android.view.KeyEvent;
import android.widget.TextView;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowDrawable;
import com.xtremelabs.robolectric.shadows.ShadowView;
import java.util.ArrayList;
import java.util.List;

@Implements(value=TextView.class)
public class ShadowTextView
extends ShadowView {
    private CharSequence text = "";
    private CompoundDrawables compoundDrawablesImpl;
    private Integer textColorHexValue;
    private Integer hintColorHexValue;
    private float textSize = 14.0f;
    private boolean autoLinkPhoneNumbers;
    private int autoLinkMask;
    private CharSequence hintText;
    private int compoundDrawablePadding;
    private MovementMethod movementMethod;
    private boolean linksClickable;
    private int gravity;
    private TextView.OnEditorActionListener onEditorActionListener;
    private int imeOptions = 0;
    private int textAppearanceId;
    private TransformationMethod transformationMethod;
    private int inputType;
    protected int selectionStart = 0;
    protected int selectionEnd = 0;
    private List<TextWatcher> watchers = new ArrayList<TextWatcher>();
    private List<Integer> previousKeyCodes = new ArrayList<Integer>();
    private List<KeyEvent> previousKeyEvents = new ArrayList<KeyEvent>();

    @Override
    public void applyAttributes() {
        super.applyAttributes();
        this.applyTextAttribute();
        this.applyTextColorAttribute();
        this.applyHintAttribute();
        this.applyHintColorAttribute();
        this.applyCompoundDrawablesWithIntrinsicBoundsAttributes();
    }

    @Implementation(i18nSafe=false)
    public void setText(CharSequence text) {
        if (text == null) {
            text = "";
        }
        this.sendBeforeTextChanged(text);
        CharSequence oldValue = this.text;
        this.text = text;
        this.sendOnTextChanged(oldValue);
        this.sendAfterTextChanged();
    }

    @Implementation
    public final void append(CharSequence text) {
        boolean isSelectStartAtEnd = this.selectionStart == this.text.length();
        boolean isSelectEndAtEnd = this.selectionEnd == this.text.length();
        CharSequence oldValue = this.text;
        StringBuffer sb = new StringBuffer(this.text);
        sb.append(text);
        this.sendBeforeTextChanged(sb.toString());
        this.text = sb.toString();
        if (isSelectStartAtEnd) {
            this.selectionStart = this.text.length();
        }
        if (isSelectEndAtEnd) {
            this.selectionEnd = this.text.length();
        }
        this.sendOnTextChanged(oldValue);
        this.sendAfterTextChanged();
    }

    @Implementation
    public void setText(int textResourceId) {
        this.sendBeforeTextChanged(this.text);
        CharSequence oldValue = this.text;
        this.text = this.getResources().getText(textResourceId);
        this.sendOnTextChanged(oldValue);
        this.sendAfterTextChanged();
    }

    private void sendAfterTextChanged() {
        for (TextWatcher watcher : this.watchers) {
            watcher.afterTextChanged((Editable)new SpannableStringBuilder(this.getText()));
        }
    }

    private void sendOnTextChanged(CharSequence oldValue) {
        for (TextWatcher watcher : this.watchers) {
            watcher.onTextChanged(this.text, 0, oldValue.length(), this.text.length());
        }
    }

    private void sendBeforeTextChanged(CharSequence newValue) {
        for (TextWatcher watcher : this.watchers) {
            watcher.beforeTextChanged(this.text, 0, this.text.length(), newValue.length());
        }
    }

    @Implementation
    public CharSequence getText() {
        return this.text;
    }

    @Implementation
    public int length() {
        return this.text.length();
    }

    @Implementation
    public void setTextColor(int color) {
        this.textColorHexValue = color;
    }

    @Implementation
    public void setTextSize(float size) {
        this.textSize = size;
    }

    @Implementation
    public void setTextAppearance(Context context, int resid) {
        this.textAppearanceId = resid;
    }

    @Implementation
    public void setInputType(int type) {
        this.inputType = type;
    }

    @Implementation
    public int getInputType() {
        return this.inputType;
    }

    @Implementation
    public final void setHint(int resId) {
        this.hintText = this.getResources().getText(resId);
    }

    @Implementation(i18nSafe=false)
    public final void setHint(CharSequence hintText) {
        this.hintText = hintText;
    }

    @Implementation
    public CharSequence getHint() {
        return this.hintText;
    }

    @Implementation
    public final void setHintTextColor(int color) {
        this.hintColorHexValue = color;
    }

    @Implementation
    public final boolean getLinksClickable() {
        return this.linksClickable;
    }

    @Implementation
    public final void setLinksClickable(boolean whether) {
        this.linksClickable = whether;
    }

    @Implementation
    public final MovementMethod getMovementMethod() {
        return this.movementMethod;
    }

    @Implementation
    public final void setMovementMethod(MovementMethod movement) {
        this.movementMethod = movement;
    }

    @Implementation
    public URLSpan[] getUrls() {
        String[] words = ((Object)this.text).toString().split("\\s+");
        ArrayList<URLSpan> urlSpans = new ArrayList<URLSpan>();
        for (String word : words) {
            if (!word.startsWith("http://")) continue;
            urlSpans.add(new URLSpan(word));
        }
        return urlSpans.toArray(new URLSpan[urlSpans.size()]);
    }

    @Implementation
    public final void setAutoLinkMask(int mask) {
        this.autoLinkMask = mask;
        this.autoLinkPhoneNumbers = (mask & 4) != 0;
    }

    @Implementation
    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        this.compoundDrawablesImpl = new CompoundDrawables(left, top, right, bottom);
    }

    @Implementation
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        this.compoundDrawablesImpl = new CompoundDrawables(left, top, right, bottom);
    }

    @Implementation
    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        this.compoundDrawablesImpl = new CompoundDrawables(left, top, right, bottom);
    }

    @Implementation
    public Drawable[] getCompoundDrawables() {
        if (this.compoundDrawablesImpl == null) {
            return new Drawable[]{null, null, null, null};
        }
        return new Drawable[]{this.compoundDrawablesImpl.leftDrawable, this.compoundDrawablesImpl.topDrawable, this.compoundDrawablesImpl.rightDrawable, this.compoundDrawablesImpl.bottomDrawable};
    }

    @Implementation
    public void setCompoundDrawablePadding(int compoundDrawablePadding) {
        this.compoundDrawablePadding = compoundDrawablePadding;
    }

    @Implementation
    public int getCompoundDrawablePadding() {
        return this.compoundDrawablePadding;
    }

    @Implementation
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        if (this.onKeyListener != null) {
            return this.onKeyListener.onKey(this.realView, keyCode, event);
        }
        return false;
    }

    @Implementation
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        if (this.onKeyListener != null) {
            return this.onKeyListener.onKey(this.realView, keyCode, event);
        }
        return false;
    }

    public int getPreviousKeyCode(int index) {
        return this.previousKeyCodes.get(index);
    }

    public KeyEvent getPreviousKeyEvent(int index) {
        return this.previousKeyEvents.get(index);
    }

    @Implementation
    public int getGravity() {
        return this.gravity;
    }

    @Implementation
    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    @Implementation
    public int getImeOptions() {
        return this.imeOptions;
    }

    @Implementation
    public void setImeOptions(int imeOptions) {
        this.imeOptions = imeOptions;
    }

    @Override
    public String innerText() {
        return this.text == null || this.getVisibility() != 0 ? "" : ((Object)this.text).toString();
    }

    @Implementation
    public boolean equals(Object o) {
        return super.equals(Robolectric.shadowOf_(o));
    }

    @Implementation
    public int hashCode() {
        return super.hashCode();
    }

    public CompoundDrawables getCompoundDrawablesImpl() {
        return this.compoundDrawablesImpl;
    }

    void setCompoundDrawablesImpl(CompoundDrawables compoundDrawablesImpl) {
        this.compoundDrawablesImpl = compoundDrawablesImpl;
    }

    public Integer getTextColorHexValue() {
        return this.textColorHexValue;
    }

    public int getTextAppearanceId() {
        return this.textAppearanceId;
    }

    public Integer getHintColorHexValue() {
        return this.hintColorHexValue;
    }

    @Implementation
    public float getTextSize() {
        return this.textSize;
    }

    public boolean isAutoLinkPhoneNumbers() {
        return this.autoLinkPhoneNumbers;
    }

    private void applyTextAttribute() {
        String text = this.attributeSet.getAttributeValue("android", "text");
        if (text != null) {
            if (text.startsWith("@string/")) {
                int textResId = this.attributeSet.getAttributeResourceValue("android", "text", 0);
                text = this.context.getResources().getString(textResId);
            }
            this.setText(text);
        }
    }

    private void applyTextColorAttribute() {
        String colorValue = this.attributeSet.getAttributeValue("android", "textColor");
        if (colorValue != null) {
            if (colorValue.startsWith("@color/") || colorValue.startsWith("@android:color/")) {
                int colorResId = this.attributeSet.getAttributeResourceValue("android", "textColor", 0);
                this.setTextColor(this.context.getResources().getColor(colorResId));
            } else if (colorValue.startsWith("#")) {
                int colorFromHex = (int)Long.valueOf(colorValue.replaceAll("#", ""), 16).longValue();
                this.setTextColor(colorFromHex);
            }
        }
    }

    private void applyHintAttribute() {
        String hint = this.attributeSet.getAttributeValue("android", "hint");
        if (hint != null) {
            if (hint.startsWith("@string/")) {
                int textResId = this.attributeSet.getAttributeResourceValue("android", "hint", 0);
                hint = this.context.getResources().getString(textResId);
            }
            this.setHint(hint);
        }
    }

    private void applyHintColorAttribute() {
        String colorValue = this.attributeSet.getAttributeValue("android", "hintColor");
        if (colorValue != null) {
            if (colorValue.startsWith("@color/") || colorValue.startsWith("@android:color/")) {
                int colorResId = this.attributeSet.getAttributeResourceValue("android", "hintColor", 0);
                this.setHintTextColor(this.context.getResources().getColor(colorResId));
            } else if (colorValue.startsWith("#")) {
                int colorFromHex = (int)Long.valueOf(colorValue.replaceAll("#", ""), 16).longValue();
                this.setHintTextColor(colorFromHex);
            }
        }
    }

    private void applyCompoundDrawablesWithIntrinsicBoundsAttributes() {
        this.setCompoundDrawablesWithIntrinsicBounds(this.attributeSet.getAttributeResourceValue("android", "drawableLeft", 0), this.attributeSet.getAttributeResourceValue("android", "drawableTop", 0), this.attributeSet.getAttributeResourceValue("android", "drawableRight", 0), this.attributeSet.getAttributeResourceValue("android", "drawableBottom", 0));
    }

    @Implementation
    public void setOnEditorActionListener(TextView.OnEditorActionListener onEditorActionListener) {
        this.onEditorActionListener = onEditorActionListener;
    }

    public void triggerEditorAction(int imeAction) {
        if (this.onEditorActionListener != null) {
            this.onEditorActionListener.onEditorAction((TextView)this.realView, imeAction, null);
        }
    }

    @Implementation
    public void setTransformationMethod(TransformationMethod transformationMethod) {
        this.transformationMethod = transformationMethod;
    }

    @Implementation
    public TransformationMethod getTransformationMethod() {
        return this.transformationMethod;
    }

    @Implementation
    public void addTextChangedListener(TextWatcher watcher) {
        this.watchers.add(watcher);
    }

    @Implementation
    public void removeTextChangedListener(TextWatcher watcher) {
        this.watchers.remove(watcher);
    }

    @Implementation
    public TextPaint getPaint() {
        return new TextPaint();
    }

    public void setSelection(int index) {
        this.setSelection(index, index);
    }

    public void setSelection(int start, int end) {
        this.selectionStart = start;
        this.selectionEnd = end;
    }

    @Implementation
    public int getSelectionStart() {
        return this.selectionStart;
    }

    @Implementation
    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public List<TextWatcher> getWatchers() {
        return this.watchers;
    }

    public static class CompoundDrawables {
        public Drawable leftDrawable;
        public Drawable topDrawable;
        public Drawable rightDrawable;
        public Drawable bottomDrawable;

        public CompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
            this.leftDrawable = left;
            this.topDrawable = top;
            this.rightDrawable = right;
            this.bottomDrawable = bottom;
        }

        public CompoundDrawables(int left, int top, int right, int bottom) {
            this.leftDrawable = left != 0 ? ShadowDrawable.createFromResourceId(left) : null;
            this.topDrawable = top != 0 ? ShadowDrawable.createFromResourceId(top) : null;
            this.rightDrawable = right != 0 ? ShadowDrawable.createFromResourceId(right) : null;
            this.bottomDrawable = bottom != 0 ? ShadowDrawable.createFromResourceId(bottom) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundDrawables that = (CompoundDrawables)o;
            if (this.getBottom() != that.getBottom()) {
                return false;
            }
            if (this.getLeft() != that.getLeft()) {
                return false;
            }
            if (this.getRight() != that.getRight()) {
                return false;
            }
            return this.getTop() == that.getTop();
        }

        public int hashCode() {
            int result = this.getLeft();
            result = 31 * result + this.getTop();
            result = 31 * result + this.getRight();
            result = 31 * result + this.getBottom();
            return result;
        }

        public String toString() {
            return "CompoundDrawables{left=" + this.getLeft() + ", top=" + this.getTop() + ", right=" + this.getRight() + ", bottom=" + this.getBottom() + '}';
        }

        public int getLeft() {
            return Robolectric.shadowOf(this.leftDrawable).getLoadedFromResourceId();
        }

        public int getTop() {
            return Robolectric.shadowOf(this.topDrawable).getLoadedFromResourceId();
        }

        public int getRight() {
            return Robolectric.shadowOf(this.rightDrawable).getLoadedFromResourceId();
        }

        public int getBottom() {
            return Robolectric.shadowOf(this.bottomDrawable).getLoadedFromResourceId();
        }
    }
}

