/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.text.format.Time;
import android.util.TimeFormatException;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

@Implements(value=Time.class)
public class ShadowTime {
    @RealObject
    private Time time;

    public void __constructor__() {
        this.__constructor__(ShadowTime.getCurrentTimezone());
    }

    public void __constructor__(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.time.timezone = timezone;
        this.time.year = 1970;
        this.time.monthDay = 1;
        this.time.isDst = -1;
    }

    public void __constructor__(Time other) {
        this.set(other);
    }

    @Implementation
    public void set(Time other) {
        this.time.timezone = other.timezone;
        this.time.second = other.second;
        this.time.minute = other.minute;
        this.time.hour = other.hour;
        this.time.monthDay = other.monthDay;
        this.time.month = other.month;
        this.time.year = other.year;
        this.time.weekDay = other.weekDay;
        this.time.yearDay = other.yearDay;
        this.time.isDst = other.isDst;
        this.time.gmtoff = other.gmtoff;
    }

    @Implementation
    public void setToNow() {
        this.set(System.currentTimeMillis());
    }

    @Implementation
    public void set(long millis) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(millis);
        this.set(c.get(13), c.get(12), c.get(11), c.get(5), c.get(2), c.get(1));
    }

    @Implementation
    public long toMillis(boolean ignoreDst) {
        Calendar c = this.getCalendar();
        return c.getTimeInMillis();
    }

    @Implementation
    public void set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.time.second = second;
        this.time.minute = minute;
        this.time.hour = hour;
        this.time.monthDay = monthDay;
        this.time.month = month;
        this.time.year = year;
        this.time.weekDay = 0;
        this.time.yearDay = 0;
        this.time.isDst = -1;
        this.time.gmtoff = 0L;
    }

    @Implementation
    public void set(int monthDay, int month, int year) {
        this.set(0, 0, 0, monthDay, month, year);
    }

    @Implementation
    public void clear(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.time.timezone = timezone;
        this.time.allDay = false;
        this.time.second = 0;
        this.time.minute = 0;
        this.time.hour = 0;
        this.time.monthDay = 0;
        this.time.month = 0;
        this.time.year = 0;
        this.time.weekDay = 0;
        this.time.yearDay = 0;
        this.time.gmtoff = 0L;
        this.time.isDst = -1;
    }

    @Implementation
    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    @Implementation
    public static int compare(Time a, Time b) {
        long bms;
        long ams = a.toMillis(false);
        if (ams == (bms = b.toMillis(false))) {
            return 0;
        }
        if (ams < bms) {
            return -1;
        }
        return 1;
    }

    @Implementation
    public boolean before(Time other) {
        return Time.compare((Time)this.time, (Time)other) < 0;
    }

    @Implementation
    public boolean after(Time other) {
        return Time.compare((Time)this.time, (Time)other) > 0;
    }

    @Implementation
    public boolean parse(String timeString) {
        TimeZone tz;
        if (timeString.endsWith("Z")) {
            timeString = timeString.substring(0, timeString.length() - 1);
            tz = TimeZone.getTimeZone("UTC");
        } else {
            tz = TimeZone.getTimeZone(this.time.timezone);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        SimpleDateFormat dfShort = new SimpleDateFormat("yyyyMMdd");
        df.setTimeZone(tz);
        dfShort.setTimeZone(tz);
        this.time.timezone = tz.getID();
        try {
            this.set(df.parse(timeString).getTime());
        }
        catch (ParseException e) {
            try {
                this.set(dfShort.parse(timeString).getTime());
            }
            catch (ParseException e2) {
                this.throwTimeFormatException();
            }
        }
        return "UTC".equals(tz.getID());
    }

    @Implementation
    public String format(String format) {
        return new Strftime(format, Locale.getDefault()).format(new Date(this.toMillis(false)));
    }

    @Implementation
    public String format2445() {
        return this.format("%Y%m%dT%H%M%S");
    }

    @Implementation
    public String format3339(boolean allDay) {
        if (allDay) {
            return this.format("%Y-%m-%d");
        }
        if ("UTC".equals(this.time.timezone)) {
            return this.format("%Y-%m-%dT%H:%M:%S.000Z");
        }
        String base = this.format("%Y-%m-%dT%H:%M:%S.000");
        String sign = this.time.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.time.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format("%s%s%02d:%02d", base, sign, hours, minutes);
    }

    private void throwTimeFormatException() {
        try {
            Constructor c = TimeFormatException.class.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            throw (TimeFormatException)c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Calendar getCalendar() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(this.time.timezone));
        c.set(this.time.year, this.time.month, this.time.monthDay, this.time.hour, this.time.minute, this.time.second);
        c.set(14, 0);
        return c;
    }

    public static class Strftime {
        protected static Properties translate = new Properties();
        protected SimpleDateFormat simpleDateFormat;

        public Strftime(String origFormat) {
            String convertedFormat = this.convertDateFormat(origFormat);
            this.simpleDateFormat = new SimpleDateFormat(convertedFormat);
        }

        public Strftime(String origFormat, Locale locale) {
            String convertedFormat = this.convertDateFormat(origFormat);
            this.simpleDateFormat = new SimpleDateFormat(convertedFormat, locale);
        }

        public String format(Date date) {
            return this.simpleDateFormat.format(date);
        }

        public TimeZone getTimeZone() {
            return this.simpleDateFormat.getTimeZone();
        }

        public void setTimeZone(TimeZone timeZone) {
            this.simpleDateFormat.setTimeZone(timeZone);
        }

        protected String convertDateFormat(String pattern) {
            char lastChar;
            boolean inside = false;
            boolean mark = false;
            boolean modifiedCommand = false;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '%' && !mark) {
                    mark = true;
                    continue;
                }
                if (mark) {
                    if (modifiedCommand) {
                        modifiedCommand = false;
                        mark = false;
                        continue;
                    }
                    inside = this.translateCommand(buf, pattern, i, inside);
                    if (c == 'O' || c == 'E') {
                        modifiedCommand = true;
                        continue;
                    }
                    mark = false;
                    continue;
                }
                if (!inside && c != ' ') {
                    buf.append("'");
                    inside = true;
                }
                buf.append(c);
            }
            if (buf.length() > 0 && (lastChar = buf.charAt(buf.length() - 1)) != '\'' && inside) {
                buf.append('\'');
            }
            return buf.toString();
        }

        protected String quote(String str, boolean insideQuotes) {
            String retVal = str;
            if (!insideQuotes) {
                retVal = '\'' + retVal + '\'';
            }
            return retVal;
        }

        protected boolean translateCommand(StringBuffer buf, String pattern, int index, boolean oldInside) {
            char firstChar = pattern.charAt(index);
            boolean newInside = oldInside;
            if (firstChar == 'O' || firstChar == 'E') {
                if (index + 1 < pattern.length()) {
                    newInside = this.translateCommand(buf, pattern, index + 1, oldInside);
                } else {
                    buf.append(this.quote("%" + firstChar, oldInside));
                }
            } else {
                String command = translate.getProperty(String.valueOf(firstChar));
                if (command == null) {
                    buf.append(this.quote("%" + firstChar, oldInside));
                } else {
                    if (oldInside) {
                        buf.append('\'');
                    }
                    buf.append(command);
                    newInside = false;
                }
            }
            return newInside;
        }

        static {
            translate.put("a", "EEE");
            translate.put("A", "EEEE");
            translate.put("b", "MMM");
            translate.put("B", "MMMM");
            translate.put("c", "EEE MMM d HH:mm:ss yyyy");
            translate.put("d", "dd");
            translate.put("D", "MM/dd/yy");
            translate.put("e", "dd");
            translate.put("F", "yyyy-MM-dd");
            translate.put("g", "yy");
            translate.put("G", "yyyy");
            translate.put("H", "HH");
            translate.put("h", "MMM");
            translate.put("I", "hh");
            translate.put("j", "DDD");
            translate.put("k", "HH");
            translate.put("l", "hh");
            translate.put("m", "MM");
            translate.put("M", "mm");
            translate.put("n", "\n");
            translate.put("p", "a");
            translate.put("P", "a");
            translate.put("r", "hh:mm:ss a");
            translate.put("R", "HH:mm");
            translate.put("S", "ss");
            translate.put("t", "\t");
            translate.put("T", "HH:mm:ss");
            translate.put("V", "ww");
            translate.put("X", "HH:mm:ss");
            translate.put("x", "MM/dd/yy");
            translate.put("y", "yy");
            translate.put("Y", "yyyy");
            translate.put("Z", "z");
            translate.put("z", "Z");
            translate.put("%", "%");
        }
    }
}

