/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import java.util.List;

@Implements(value=Toast.class)
public class ShadowToast {
    private String text;
    private int gravity;
    private View view;
    @RealObject
    Toast toast;

    @Implementation
    public static Toast makeText(Context context, int resId, int duration) {
        return ShadowToast.makeText(context, context.getResources().getString(resId), duration);
    }

    @Implementation(i18nSafe=false)
    public static Toast makeText(Context context, CharSequence text, int duration) {
        Toast toast = new Toast(null);
        Robolectric.shadowOf((Toast)toast).text = ((Object)text).toString();
        return toast;
    }

    @Implementation
    public void show() {
        Robolectric.getShadowApplication().getShownToasts().add(this.toast);
    }

    @Implementation
    public void setView(View view) {
        this.view = view;
    }

    @Implementation
    public View getView() {
        return this.view;
    }

    @Implementation
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.gravity = gravity;
    }

    @Implementation
    public int getGravity() {
        return this.gravity;
    }

    public static void reset() {
        Robolectric.getShadowApplication().getShownToasts().clear();
    }

    public static int shownToastCount() {
        return Robolectric.getShadowApplication().getShownToasts().size();
    }

    public static boolean showedCustomToast(CharSequence message, int layoutResourceIdToCheckForMessage) {
        for (Toast toast : Robolectric.getShadowApplication().getShownToasts()) {
            String text = ((Object)((TextView)toast.getView().findViewById(layoutResourceIdToCheckForMessage)).getText()).toString();
            if (!text.equals(((Object)message).toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean showedToast(CharSequence message) {
        for (Toast toast : Robolectric.getShadowApplication().getShownToasts()) {
            String text = Robolectric.shadowOf((Toast)toast).text;
            if (text == null || !text.equals(((Object)message).toString())) continue;
            return true;
        }
        return false;
    }

    public static String getTextOfLatestToast() {
        List<Toast> shownToasts = Robolectric.getShadowApplication().getShownToasts();
        return shownToasts.size() == 0 ? null : Robolectric.shadowOf((Toast)shownToasts.get((int)(shownToasts.size() - 1))).text;
    }

    public static Toast getLatestToast() {
        List<Toast> shownToasts = Robolectric.getShadowApplication().getShownToasts();
        return shownToasts.size() == 0 ? null : shownToasts.get(shownToasts.size() - 1);
    }
}

