/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.UriMatcher;
import android.net.Uri;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Implements(value=UriMatcher.class)
public class ShadowUriMatcher {
    public MatchNode rootNode;

    public void __constructor__(int code) {
        this.rootNode = new MatchNode(code);
    }

    @Implementation
    public void addURI(String authority, String path, int code) {
        MatchNode authNode = this.rootNode.map.get(authority);
        if (authNode == null) {
            authNode = new MatchNode(this.rootNode.code);
            this.rootNode.map.put(authority, authNode);
        }
        String[] segments = path.split("/");
        this.addNodes(authNode, Arrays.asList(segments), code);
    }

    @Implementation
    public int match(Uri uri) {
        String auth = uri.getAuthority();
        List segments = uri.getPathSegments();
        if (!this.rootNode.map.containsKey(auth)) {
            return this.rootNode.code;
        }
        return this.matchSegments(this.rootNode.map.get(auth), segments);
    }

    private int matchSegments(MatchNode node, List<String> segments) {
        if (segments.isEmpty()) {
            return node.code;
        }
        String segment = segments.get(0);
        segments = segments.subList(1, segments.size());
        if (node.map.containsKey(segment)) {
            return this.matchSegments(node.map.get(segment), segments);
        }
        if (node.number != null) {
            try {
                long id = Long.parseLong(segment);
                if (id >= 0L) {
                    return this.matchSegments(node.number, segments);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (node.text != null) {
            return this.matchSegments(node.text, segments);
        }
        return this.rootNode.code;
    }

    private void addNodes(MatchNode baseNode, List<String> segments, int code) {
        MatchNode nextNode = null;
        String segment = segments.get(0);
        if (segment.equals("#")) {
            nextNode = baseNode.number;
            if (nextNode == null) {
                baseNode.number = nextNode = new MatchNode(this.rootNode.code);
            }
        } else if (segment.equals("*")) {
            nextNode = baseNode.text;
            if (nextNode == null) {
                baseNode.text = nextNode = new MatchNode(this.rootNode.code);
            }
        } else {
            nextNode = baseNode.map.get(segment);
            if (nextNode == null) {
                nextNode = new MatchNode(this.rootNode.code);
                baseNode.map.put(segment, nextNode);
            }
        }
        if (segments.size() > 1) {
            this.addNodes(nextNode, segments.subList(1, segments.size()), code);
        } else {
            nextNode.code = code;
        }
    }

    public static class MatchNode {
        public int code = -1;
        public HashMap<String, MatchNode> map = new HashMap();
        public MatchNode number;
        public MatchNode text;

        public MatchNode(int code) {
            this.code = code;
        }
    }
}

