/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.shadows.ShadowLayoutInflater;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Implements(value=View.class)
public class ShadowView {
    @RealObject
    protected View realView;
    private int id;
    ShadowView parent;
    protected Context context;
    private boolean selected;
    private View.OnClickListener onClickListener;
    private View.OnLongClickListener onLongClickListener;
    private Object tag;
    private boolean enabled = true;
    private int visibility = 0;
    int left;
    int top;
    int right;
    int bottom;
    private int paddingLeft;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(0, 0);
    private Map<Integer, Object> tags = new HashMap<Integer, Object>();
    private boolean clickable;
    protected boolean focusable;
    boolean focusableInTouchMode;
    private int backgroundResourceId = -1;
    private int backgroundColor;
    protected View.OnKeyListener onKeyListener;
    private boolean isFocused;
    private View.OnFocusChangeListener onFocusChangeListener;
    private boolean wasInvalidated;
    private View.OnTouchListener onTouchListener;
    protected AttributeSet attributeSet;
    private boolean drawingCacheEnabled;
    public Point scrollToCoordinates;
    private boolean didRequestLayout;
    private Drawable background;
    private Animation animation;
    private ViewTreeObserver viewTreeObserver;
    private MotionEvent lastTouchEvent;

    public void __constructor__(Context context) {
        this.__constructor__(context, null);
    }

    public void __constructor__(Context context, AttributeSet attributeSet) {
        this.__constructor__(context, attributeSet, 0);
    }

    public void __constructor__(Context context, AttributeSet attributeSet, int defStyle) {
        this.context = context;
        this.attributeSet = attributeSet;
        if (attributeSet != null) {
            this.applyAttributes();
        }
    }

    public void applyAttributes() {
        this.applyIdAttribute();
        this.applyVisibilityAttribute();
        this.applyEnabledAttribute();
        this.applyBackgroundAttribute();
        this.applyTagAttribute();
        this.applyOnClickAttribute();
    }

    @Implementation
    public void setId(int id) {
        this.id = id;
    }

    @Implementation
    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Implementation
    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
        if (!focusable) {
            this.setFocusableInTouchMode(false);
        }
    }

    @Implementation
    public final boolean isFocusableInTouchMode() {
        return this.focusableInTouchMode;
    }

    @Implementation
    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.focusableInTouchMode = focusableInTouchMode;
        if (focusableInTouchMode) {
            this.setFocusable(true);
        }
    }

    @Implementation
    public boolean isFocusable() {
        return this.focusable;
    }

    @Implementation
    public int getId() {
        return this.id;
    }

    @Implementation
    public static View inflate(Context context, int resource, ViewGroup root) {
        return ShadowLayoutInflater.from(context).inflate(resource, root);
    }

    @Implementation
    public View findViewById(int id) {
        if (id == this.id) {
            return this.realView;
        }
        return null;
    }

    @Implementation
    public View findViewWithTag(Object obj) {
        if (obj.equals(this.getTag())) {
            return this.realView;
        }
        return null;
    }

    @Implementation
    public View getRootView() {
        ShadowView root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        return root.realView;
    }

    @Implementation
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    @Implementation
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        this.layoutParams = params;
    }

    @Implementation
    public final ViewParent getParent() {
        return this.parent == null ? null : (ViewParent)this.parent.realView;
    }

    @Implementation
    public final Context getContext() {
        return this.context;
    }

    @Implementation
    public Resources getResources() {
        return this.context.getResources();
    }

    @Implementation
    public void setBackgroundResource(int backgroundResourceId) {
        this.backgroundResourceId = backgroundResourceId;
        this.setBackgroundDrawable(this.getResources().getDrawable(backgroundResourceId));
    }

    public int getBackgroundResourceId() {
        return this.backgroundResourceId;
    }

    @Implementation
    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.setBackgroundDrawable((Drawable)new ColorDrawable(this.getResources().getColor(color)));
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Implementation
    public void setBackgroundDrawable(Drawable d) {
        this.background = d;
    }

    @Implementation
    public Drawable getBackground() {
        return this.background;
    }

    @Implementation
    public int getVisibility() {
        return this.visibility;
    }

    @Implementation
    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    @Implementation
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Implementation
    public boolean isSelected() {
        return this.selected;
    }

    @Implementation
    public boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Implementation
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    @Implementation
    public boolean performClick() {
        if (this.onClickListener != null) {
            this.onClickListener.onClick(this.realView);
            return true;
        }
        return false;
    }

    @Implementation
    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
    }

    @Implementation
    public boolean performLongClick() {
        if (this.onLongClickListener != null) {
            this.onLongClickListener.onLongClick(this.realView);
            return true;
        }
        return false;
    }

    @Implementation
    public void setOnKeyListener(View.OnKeyListener onKeyListener) {
        this.onKeyListener = onKeyListener;
    }

    @Implementation
    public Object getTag() {
        return this.tag;
    }

    @Implementation
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Implementation
    public final int getHeight() {
        return this.bottom - this.top;
    }

    @Implementation
    public final int getWidth() {
        return this.right - this.left;
    }

    @Implementation
    public final int getMeasuredWidth() {
        return this.getWidth();
    }

    @Implementation
    public final int getMeasuredHeight() {
        return this.getHeight();
    }

    @Implementation
    public final void layout(int l, int t, int r, int b) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
    }

    @Implementation
    public void setPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
    }

    @Implementation
    public int getPaddingTop() {
        return this.paddingTop;
    }

    @Implementation
    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    @Implementation
    public int getPaddingRight() {
        return this.paddingRight;
    }

    @Implementation
    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    @Implementation
    public Object getTag(int key) {
        return this.tags.get(key);
    }

    @Implementation
    public void setTag(int key, Object value) {
        this.tags.put(key, value);
    }

    @Implementation
    public void requestLayout() {
        this.didRequestLayout = true;
    }

    public boolean didRequestLayout() {
        return this.didRequestLayout;
    }

    @Implementation
    public final boolean requestFocus() {
        return this.requestFocus(130);
    }

    @Implementation
    public final boolean requestFocus(int direction) {
        this.setViewFocus(true);
        return true;
    }

    public void setViewFocus(boolean hasFocus) {
        this.isFocused = hasFocus;
        if (this.onFocusChangeListener != null) {
            this.onFocusChangeListener.onFocusChange(this.realView, hasFocus);
        }
    }

    @Implementation
    public boolean isFocused() {
        return this.isFocused;
    }

    @Implementation
    public boolean hasFocus() {
        return this.isFocused;
    }

    @Implementation
    public void clearFocus() {
        this.setViewFocus(false);
    }

    @Implementation
    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        this.onFocusChangeListener = listener;
    }

    @Implementation
    public View.OnFocusChangeListener getOnFocusChangeListener() {
        return this.onFocusChangeListener;
    }

    @Implementation
    public void invalidate() {
        this.wasInvalidated = true;
    }

    @Implementation
    public boolean onTouchEvent(MotionEvent event) {
        this.lastTouchEvent = event;
        return false;
    }

    @Implementation
    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.onTouchListener = onTouchListener;
    }

    @Implementation
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.onTouchListener != null && this.onTouchListener.onTouch(this.realView, event)) {
            return true;
        }
        return this.realView.onTouchEvent(event);
    }

    public MotionEvent getLastTouchEvent() {
        return this.lastTouchEvent;
    }

    @Implementation
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.onKeyListener != null) {
            return this.onKeyListener.onKey(this.realView, event.getKeyCode(), event);
        }
        return false;
    }

    public String innerText() {
        return "";
    }

    public void dump() {
        this.dump(System.out, 0);
    }

    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        out.println("/>");
    }

    protected void dumpFirstPart(PrintStream out, int indent) {
        this.dumpIndent(out, indent);
        out.print("<" + this.realView.getClass().getSimpleName());
        if (this.id > 0) {
            out.print(" id=\"" + Robolectric.shadowOf(this.context).getResourceLoader().getNameForId(this.id) + "\"");
        }
    }

    protected void dumpIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
    }

    @Implementation
    public int getLeft() {
        return this.left;
    }

    @Implementation
    public int getTop() {
        return this.top;
    }

    @Implementation
    public int getRight() {
        return this.right;
    }

    @Implementation
    public int getBottom() {
        return this.bottom;
    }

    @Implementation
    public boolean isClickable() {
        return this.clickable;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void clearWasInvalidated() {
        this.wasInvalidated = false;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setFocused(boolean focused) {
        this.isFocused = focused;
    }

    public boolean derivedIsVisible() {
        for (View parent = this.realView; parent != null; parent = (View)parent.getParent()) {
            if (parent.getVisibility() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean checkedPerformClick() {
        if (!this.derivedIsVisible()) {
            throw new RuntimeException("View is not visible and cannot be clicked");
        }
        if (!this.realView.isEnabled()) {
            throw new RuntimeException("View is not enabled and cannot be clicked");
        }
        return this.realView.performClick();
    }

    public void applyFocus() {
        Boolean focusRequested;
        if (this.noParentHasFocus(this.realView) && ((focusRequested = Boolean.valueOf(this.attributeSet.getAttributeBooleanValue("android", "focus", false))).booleanValue() || this.realView.isFocusableInTouchMode())) {
            this.realView.requestFocus();
        }
    }

    private void applyIdAttribute() {
        Integer id = this.attributeSet.getAttributeResourceValue("android", "id", 0);
        if (this.getId() == 0) {
            this.setId(id);
        }
    }

    private void applyTagAttribute() {
        String tag = this.attributeSet.getAttributeValue("android", "tag");
        if (tag != null) {
            this.setTag(tag);
        }
    }

    private void applyVisibilityAttribute() {
        String visibility = this.attributeSet.getAttributeValue("android", "visibility");
        if (visibility != null) {
            if (visibility.equals("gone")) {
                this.setVisibility(8);
            } else if (visibility.equals("invisible")) {
                this.setVisibility(4);
            }
        }
    }

    private void applyEnabledAttribute() {
        this.setEnabled(this.attributeSet.getAttributeBooleanValue("android", "enabled", true));
    }

    private void applyBackgroundAttribute() {
        String source = this.attributeSet.getAttributeValue("android", "background");
        if (source != null && source.startsWith("@drawable/")) {
            this.setBackgroundResource(this.attributeSet.getAttributeResourceValue("android", "background", 0));
        }
    }

    private void applyOnClickAttribute() {
        final String handlerName = this.attributeSet.getAttributeValue("android", "onClick");
        if (handlerName == null) {
            return;
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Method mHandler;
                try {
                    mHandler = ShadowView.this.getContext().getClass().getMethod(handlerName, View.class);
                }
                catch (NoSuchMethodException e) {
                    int id = ShadowView.this.getId();
                    String idText = id == -1 ? "" : " with id '" + Robolectric.shadowOf(ShadowView.this.context).getResourceLoader().getNameForId(id) + "'";
                    throw new IllegalStateException("Could not find a method " + handlerName + "(View) in the activity " + ShadowView.this.getContext().getClass() + " for onClick handler" + " on view " + ShadowView.this.realView.getClass() + idText, e);
                }
                try {
                    mHandler.invoke((Object)ShadowView.this.getContext(), ShadowView.this.realView);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not execute non public method of the activity", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not execute method of the activity", e);
                }
            }
        });
    }

    private boolean noParentHasFocus(View view) {
        while (view != null) {
            if (view.hasFocus()) {
                return false;
            }
            view = (View)view.getParent();
        }
        return true;
    }

    public View.OnTouchListener getOnTouchListener() {
        return this.onTouchListener;
    }

    public View.OnClickListener getOnClickListener() {
        return this.onClickListener;
    }

    @Implementation
    public void setDrawingCacheEnabled(boolean drawingCacheEnabled) {
        this.drawingCacheEnabled = drawingCacheEnabled;
    }

    @Implementation
    public boolean isDrawingCacheEnabled() {
        return this.drawingCacheEnabled;
    }

    @Implementation
    public Bitmap getDrawingCache() {
        return Robolectric.newInstanceOf(Bitmap.class);
    }

    @Implementation
    public void post(Runnable action) {
        Robolectric.getUiThreadScheduler().post(action);
    }

    @Implementation
    public void postDelayed(Runnable action, long delayMills) {
        Robolectric.getUiThreadScheduler().postDelayed(action, delayMills);
    }

    @Implementation
    public void postInvalidateDelayed(long delayMilliseconds) {
        Robolectric.getUiThreadScheduler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ShadowView.this.realView.invalidate();
            }
        }, delayMilliseconds);
    }

    @Implementation
    public Animation getAnimation() {
        return this.animation;
    }

    @Implementation
    public void setAnimation(Animation anim) {
        this.animation = anim;
    }

    @Implementation
    public void startAnimation(Animation anim) {
        this.setAnimation(anim);
        this.animation.start();
    }

    @Implementation
    public void clearAnimation() {
        if (this.animation != null) {
            this.animation.cancel();
        }
    }

    @Implementation
    public void scrollTo(int x, int y) {
        this.scrollToCoordinates = new Point(x, y);
    }

    @Implementation
    public int getScrollX() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.x : 0;
    }

    @Implementation
    public int getScrollY() {
        return this.scrollToCoordinates != null ? this.scrollToCoordinates.y : 0;
    }

    @Implementation
    public ViewTreeObserver getViewTreeObserver() {
        if (this.viewTreeObserver == null) {
            this.viewTreeObserver = Robolectric.Reflection.newInstanceOf(ViewTreeObserver.class);
        }
        return this.viewTreeObserver;
    }
}

