/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowView;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Implements(value=ViewGroup.class)
public class ShadowViewGroup
extends ShadowView {
    private List<View> children = new ArrayList<View>();
    private Animation.AnimationListener animListener;
    private boolean disallowInterceptTouchEvent = false;

    @Override
    @Implementation
    public View findViewById(int id) {
        if (id == this.getId()) {
            return this.realView;
        }
        for (View child : this.children) {
            View found = child.findViewById(id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    @Implementation
    public View findViewWithTag(Object obj) {
        if (obj.equals(this.getTag())) {
            return this.realView;
        }
        for (View child : this.children) {
            View found = child.findViewWithTag(obj);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Implementation
    public void addView(View child) {
        ((ViewGroup)this.realView).addView(child, -1);
    }

    @Implementation
    public void addView(View child, int index) {
        if (index == -1) {
            this.children.add(child);
        } else {
            this.children.add(index, child);
        }
        Robolectric.shadowOf((View)child).parent = this;
    }

    @Implementation
    public void addView(View child, int width, int height) {
        ((ViewGroup)this.realView).addView(child, -1);
    }

    @Implementation
    public void addView(View child, ViewGroup.LayoutParams params) {
        ((ViewGroup)this.realView).addView(child, -1);
    }

    @Implementation
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        ((ViewGroup)this.realView).addView(child, index);
    }

    @Implementation
    public int indexOfChild(View child) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Implementation
    public int getChildCount() {
        return this.children.size();
    }

    @Implementation
    public View getChildAt(int index) {
        return this.children.get(index);
    }

    @Implementation
    public void removeAllViews() {
        for (View child : this.children) {
            Robolectric.shadowOf((View)child).parent = null;
        }
        this.children.clear();
    }

    @Implementation
    public void removeViewAt(int position) {
        Robolectric.shadowOf((View)this.children.remove((int)position)).parent = null;
    }

    @Override
    @Implementation
    public boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        for (View child : this.children) {
            if (!child.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Implementation
    public void clearFocus() {
        if (this.hasFocus()) {
            super.clearFocus();
            for (View child : this.children) {
                child.clearFocus();
            }
        }
    }

    @Override
    public String innerText() {
        String innerText = "";
        String delimiter = "";
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            String childText = Robolectric.shadowOf(child).innerText();
            if (childText.length() > 0) {
                innerText = innerText + delimiter;
                delimiter = " ";
            }
            innerText = innerText + childText;
        }
        return innerText;
    }

    @Override
    public void dump(PrintStream out, int indent) {
        this.dumpFirstPart(out, indent);
        if (this.children.size() > 0) {
            out.println(">");
            for (View child : this.children) {
                Robolectric.shadowOf(child).dump(out, indent + 2);
            }
            this.dumpIndent(out, indent);
            out.println("</" + this.realView.getClass().getSimpleName() + ">");
        } else {
            out.println("/>");
        }
    }

    @Implementation
    public void setLayoutAnimationListener(Animation.AnimationListener listener) {
        this.animListener = listener;
    }

    @Implementation
    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.animListener;
    }

    @Implementation
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.disallowInterceptTouchEvent = disallowIntercept;
    }

    public boolean getDisallowInterceptTouchEvent() {
        return this.disallowInterceptTouchEvent;
    }
}

