/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.view.View;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;

@Implements(value=View.MeasureSpec.class)
public class ShadowViewMeasureSpec {
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;

    @Implementation
    public static int getMode(int measureSpec) {
        return measureSpec & 0xC0000000;
    }

    @Implementation
    public static int getSize(int measureSpec) {
        return measureSpec & 0x3FFFFFFF;
    }

    @Implementation
    public static int makeMeasureSpec(int size, int mode) {
        return size + mode;
    }

    @Implementation
    public static String toString(int measureSpec) {
        int mode = ShadowViewMeasureSpec.getMode(measureSpec);
        int size = ShadowViewMeasureSpec.getSize(measureSpec);
        StringBuilder sb = new StringBuilder("MeasureSpec: ");
        if (mode == 0) {
            sb.append("UNSPECIFIED ");
        } else if (mode == 0x40000000) {
            sb.append("EXACTLY ");
        } else if (mode == Integer.MIN_VALUE) {
            sb.append("AT_MOST ");
        } else {
            sb.append(mode).append(" ");
        }
        sb.append(size);
        return sb.toString();
    }
}

