/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.internal.RealObject;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.shadows.ShadowView;
import java.lang.ref.WeakReference;

@Implements(value=ViewStub.class)
public class ShadowViewStub
extends ShadowView {
    @RealObject
    ViewStub viewStub;
    private int mLayoutResource = 0;
    private int mInflatedId;
    private WeakReference<View> mInflatedViewRef;
    private ViewStub.OnInflateListener mInflateListener;

    @Override
    public void applyAttributes() {
        String layoutResId;
        super.applyAttributes();
        String inflatedId = this.attributeSet.getAttributeValue("android", "inflatedId");
        if (inflatedId != null) {
            this.mInflatedId = this.getResourceId(inflatedId);
        }
        if ((layoutResId = this.attributeSet.getAttributeValue("android", "layout")) != null) {
            this.mLayoutResource = this.getResourceId(layoutResId);
        }
    }

    private Integer getResourceId(String inflatedId) {
        ResourceExtractor resourceExtractor = Robolectric.getShadowApplication().getResourceLoader().getResourceExtractor();
        return resourceExtractor.getResourceId(inflatedId, false);
    }

    @Implementation
    public int getInflatedId() {
        return this.mInflatedId;
    }

    @Implementation
    public void setInflatedId(int inflatedId) {
        this.mInflatedId = inflatedId;
    }

    @Implementation
    public int getLayoutResource() {
        return this.mLayoutResource;
    }

    @Implementation
    public void setLayoutResource(int layoutResource) {
        this.mLayoutResource = layoutResource;
    }

    @Implementation
    public View inflate() {
        ViewParent viewParent = this.viewStub.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (this.mLayoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                LayoutInflater factory = LayoutInflater.from((Context)this.viewStub.getContext());
                View view = factory.inflate(this.mLayoutResource, parent, false);
                if (this.mInflatedId != -1) {
                    view.setId(this.mInflatedId);
                }
                int index = parent.indexOfChild((View)this.viewStub);
                parent.removeViewAt(index);
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams != null) {
                    parent.addView(view, index, layoutParams);
                } else {
                    parent.addView(view, index);
                }
                this.mInflatedViewRef = new WeakReference<View>(view);
                if (this.mInflateListener != null) {
                    this.mInflateListener.onInflate(this.viewStub, view);
                }
                return view;
            }
            throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }
}

