/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.shadows;

import android.content.Context;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.internal.Implementation;
import com.xtremelabs.robolectric.internal.Implements;
import com.xtremelabs.robolectric.shadows.ShadowAbsoluteLayout;
import java.util.HashMap;

@Implements(value=WebView.class)
public class ShadowWebView
extends ShadowAbsoluteLayout {
    private String lastUrl;
    private HashMap<String, Object> javascriptInterfaces = new HashMap();
    private WebSettings webSettings = Robolectric.newInstanceOf(WebSettings.class);
    private WebViewClient webViewClient = null;
    private boolean runFlag = false;
    private boolean clearCacheCalled = false;
    private boolean clearCacheIncludeDiskFiles = false;
    private boolean clearFormDataCalled = false;
    private boolean clearHistoryCalled = false;
    private boolean clearViewCalled = false;
    private boolean destroyCalled = false;
    private WebChromeClient webChromeClient;
    private boolean canGoBack;
    private int goBackInvocations = 0;
    private LoadData lastLoadData;
    private LoadDataWithBaseURL lastLoadDataWithBaseURL;

    @Override
    public void __constructor__(Context context, AttributeSet attributeSet) {
        super.__constructor__(context, attributeSet);
    }

    @Implementation
    public void loadUrl(String url) {
        this.lastUrl = url;
    }

    @Implementation
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.lastLoadDataWithBaseURL = new LoadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
    }

    @Implementation
    public void loadData(String data, String mimeType, String encoding) {
        this.lastLoadData = new LoadData(data, mimeType, encoding);
    }

    public String getLastLoadedUrl() {
        return this.lastUrl;
    }

    @Implementation
    public WebSettings getSettings() {
        return this.webSettings;
    }

    @Implementation
    public void setWebViewClient(WebViewClient client) {
        this.webViewClient = client;
    }

    @Implementation
    public void setWebChromeClient(WebChromeClient client) {
        this.webChromeClient = client;
    }

    public WebViewClient getWebViewClient() {
        return this.webViewClient;
    }

    @Implementation
    public void addJavascriptInterface(Object obj, String interfaceName) {
        this.javascriptInterfaces.put(interfaceName, obj);
    }

    public Object getJavascriptInterface(String interfaceName) {
        return this.javascriptInterfaces.get(interfaceName);
    }

    @Implementation
    public void clearCache(boolean includeDiskFiles) {
        this.clearCacheCalled = true;
        this.clearCacheIncludeDiskFiles = includeDiskFiles;
    }

    public boolean wasClearCacheCalled() {
        return this.clearCacheCalled;
    }

    public boolean didClearCacheIncludeDiskFiles() {
        return this.clearCacheIncludeDiskFiles;
    }

    @Implementation
    public void clearFormData() {
        this.clearFormDataCalled = true;
    }

    public boolean wasClearFormDataCalled() {
        return this.clearFormDataCalled;
    }

    @Implementation
    public void clearHistory() {
        this.clearHistoryCalled = true;
    }

    public boolean wasClearHistoryCalled() {
        return this.clearHistoryCalled;
    }

    @Implementation
    public void clearView() {
        this.clearViewCalled = true;
    }

    public boolean wasClearViewCalled() {
        return this.clearViewCalled;
    }

    @Implementation
    public void destroy() {
        this.destroyCalled = true;
    }

    public boolean wasDestroyCalled() {
        return this.destroyCalled;
    }

    @Override
    @Implementation
    public void post(Runnable action) {
        action.run();
        this.runFlag = true;
    }

    public boolean getRunFlag() {
        return this.runFlag;
    }

    public WebChromeClient getWebChromeClient() {
        return this.webChromeClient;
    }

    @Implementation
    public boolean canGoBack() {
        return this.canGoBack;
    }

    @Implementation
    public void goBack() {
        ++this.goBackInvocations;
    }

    public int getGoBackInvocations() {
        return this.goBackInvocations;
    }

    public void setCanGoBack(boolean canGoBack) {
        this.canGoBack = canGoBack;
    }

    public LoadData getLastLoadData() {
        return this.lastLoadData;
    }

    public LoadDataWithBaseURL getLastLoadDataWithBaseURL() {
        return this.lastLoadDataWithBaseURL;
    }

    public class LoadData {
        public final String data;
        public final String mimeType;
        public final String encoding;

        public LoadData(String data, String mimeType, String encoding) {
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
        }
    }

    public class LoadDataWithBaseURL {
        public final String baseUrl;
        public final String data;
        public final String mimeType;
        public final String encoding;
        public final String historyUrl;

        public LoadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
            this.baseUrl = baseUrl;
            this.data = data;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.historyUrl = historyUrl;
        }
    }
}

