/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.tester.android.content;

import android.content.SharedPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestSharedPreferences
implements SharedPreferences {
    public Map<String, Map<String, Object>> content;
    protected String filename;
    public int mode;
    private ArrayList<SharedPreferences.OnSharedPreferenceChangeListener> listeners;

    public TestSharedPreferences(Map<String, Map<String, Object>> content, String name, int mode) {
        this.content = content;
        this.filename = name;
        this.mode = mode;
        if (!content.containsKey(name)) {
            content.put(name, new HashMap());
        }
        this.listeners = new ArrayList();
    }

    public Map<String, ?> getAll() {
        return new HashMap<String, Object>(this.content.get(this.filename));
    }

    public String getString(String key, String defValue) {
        return (String)this.getValue(key, defValue);
    }

    private Object getValue(String key, Object defValue) {
        Object value;
        Map<String, Object> fileHash = this.content.get(this.filename);
        if (fileHash != null && (value = fileHash.get(key)) != null) {
            return value;
        }
        return defValue;
    }

    public int getInt(String key, int defValue) {
        return (Integer)this.getValue(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return (Long)this.getValue(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return ((Float)this.getValue(key, Float.valueOf(defValue))).floatValue();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return (Boolean)this.getValue(key, defValue);
    }

    public boolean contains(String key) {
        return this.content.get(this.filename).containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return new TestSharedPreferencesEditor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public boolean hasListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        return this.listeners.contains(listener);
    }

    private class TestSharedPreferencesEditor
    implements SharedPreferences.Editor {
        Map<String, Object> editsThatNeedCommit = new HashMap<String, Object>();
        Set<String> editsThatNeedRemove = new HashSet<String>();
        private boolean shouldClearOnCommit = false;

        private TestSharedPreferencesEditor() {
        }

        public SharedPreferences.Editor putString(String key, String value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.editsThatNeedCommit.put(key, Float.valueOf(value));
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.editsThatNeedCommit.put(key, value);
            this.editsThatNeedRemove.remove(key);
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.editsThatNeedRemove.add(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.shouldClearOnCommit = true;
            return this;
        }

        public boolean commit() {
            Map<String, Object> previousContent = TestSharedPreferences.this.content.get(TestSharedPreferences.this.filename);
            if (this.shouldClearOnCommit) {
                previousContent.clear();
            } else {
                for (String key : this.editsThatNeedCommit.keySet()) {
                    previousContent.put(key, this.editsThatNeedCommit.get(key));
                }
                for (String key : this.editsThatNeedRemove) {
                    previousContent.remove(key);
                }
            }
            for (String key : this.editsThatNeedCommit.keySet()) {
                previousContent.put(key, this.editsThatNeedCommit.get(key));
            }
            return true;
        }

        public void apply() {
            this.commit();
        }
    }
}

