/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.tester.android.util;

import android.util.AttributeSet;
import android.view.View;
import com.xtremelabs.robolectric.res.AttrResourceLoader;
import com.xtremelabs.robolectric.res.ResourceExtractor;
import com.xtremelabs.robolectric.util.I18nException;
import java.util.HashMap;
import java.util.Map;

public class TestAttributeSet
implements AttributeSet {
    Map<String, String> attributes = new HashMap<String, String>();
    private ResourceExtractor resourceExtractor;
    private AttrResourceLoader attrResourceLoader;
    private Class<? extends View> viewClass;
    private boolean isSystem = false;
    private static final String[] strictI18nAttrs = new String[]{"android:text", "android:title", "android:titleCondensed", "android:summary"};

    public TestAttributeSet() {
        this.attributes = new HashMap<String, String>();
    }

    public TestAttributeSet(Map<String, String> attributes, ResourceExtractor resourceExtractor, AttrResourceLoader attrResourceLoader, Class<? extends View> viewClass, boolean isSystem) {
        this.attributes = attributes;
        this.resourceExtractor = resourceExtractor;
        this.attrResourceLoader = attrResourceLoader;
        this.viewClass = viewClass;
        this.isSystem = isSystem;
    }

    public TestAttributeSet(Map<String, String> attributes) {
        this.attributes = attributes;
        this.resourceExtractor = new ResourceExtractor();
        this.attrResourceLoader = new AttrResourceLoader(this.resourceExtractor);
        this.viewClass = null;
    }

    public TestAttributeSet put(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        String value = this.getAttributeValueInMap(namespace, attribute);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    public String getAttributeValue(String namespace, String attribute) {
        return this.getAttributeValueInMap(namespace, attribute);
    }

    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValueInMap(namespace, attribute);
        if (this.attrResourceLoader.hasAttributeFor(this.viewClass, "xxx", attribute)) {
            value = this.attrResourceLoader.convertValueToEnum(this.viewClass, "xxx", attribute, value);
        }
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    public String getAttributeValue(int index) {
        throw new UnsupportedOperationException();
    }

    public String getPositionDescription() {
        throw new UnsupportedOperationException();
    }

    public int getAttributeNameResource(int index) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        String value = this.getAttributeValueInMap(namespace, attribute);
        if (this.attrResourceLoader.hasAttributeFor(this.viewClass, "xxx", attribute)) {
            value = this.attrResourceLoader.convertValueToEnum(this.viewClass, "xxx", attribute, value);
        }
        return value != null ? Float.valueOf(value).floatValue() : defaultValue;
    }

    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean getAttributeBooleanValue(int resourceId, boolean defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValueInMap(namespace, attribute);
        Integer resourceId = defaultValue;
        if (value != null) {
            resourceId = this.resourceExtractor.getResourceId(value);
        }
        return resourceId == null ? defaultValue : resourceId;
    }

    public int getAttributeResourceValue(int resourceId, int defaultValue) {
        String attrName = this.resourceExtractor.getResourceName(resourceId);
        String value = this.getAttributeValueInMap(null, attrName);
        return value == null ? defaultValue : this.resourceExtractor.getResourceId(value);
    }

    public int getAttributeIntValue(int index, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public float getAttributeFloatValue(int index, float defaultValue) {
        throw new UnsupportedOperationException();
    }

    public String getIdAttribute() {
        throw new UnsupportedOperationException();
    }

    public String getClassAttribute() {
        throw new UnsupportedOperationException();
    }

    public int getIdAttributeResourceValue(int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getStyleAttribute() {
        throw new UnsupportedOperationException();
    }

    public void validateStrictI18n() {
        for (int i = 0; i < strictI18nAttrs.length; ++i) {
            String value;
            String key = strictI18nAttrs[i];
            if (!this.attributes.containsKey(key) || (value = this.attributes.get(key)).startsWith("@string/")) continue;
            throw new I18nException("View class: " + (this.viewClass != null ? this.viewClass.getName() : "") + " has attribute: " + key + " with hardcoded value: \"" + value + "\" and is not i18n-safe.");
        }
    }

    private String getAttributeValueInMap(String namespace, String attribute) {
        String value = null;
        for (String key : this.attributes.keySet()) {
            String[] mappedKeys = new String[]{null, key};
            if (key.contains(":")) {
                mappedKeys = key.split(":");
            }
            if (!mappedKeys[1].equals(attribute) || namespace != null && namespace == "android" && (!namespace.equals("android") || !namespace.equals(mappedKeys[0]))) continue;
            value = this.attributes.get(key);
            break;
        }
        if (value != null && this.isSystem && value.startsWith("@+id")) {
            value = value.replace("@+id", "@+android:id");
        }
        return value;
    }
}

