/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.tester.android.util;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.ViewGroup;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.shadows.SerializedFragmentState;
import com.xtremelabs.robolectric.shadows.ShadowFragment;
import com.xtremelabs.robolectric.tester.android.util.TestFragmentTransaction;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class TestFragmentManager
extends FragmentManager {
    private Map<Integer, Fragment> fragmentsById = new HashMap<Integer, Fragment>();
    private Map<String, Fragment> fragmentsByTag = new HashMap<String, Fragment>();
    private FragmentActivity activity;

    public TestFragmentManager(FragmentActivity activity) {
        this.activity = activity;
    }

    public FragmentActivity getActivity() {
        return this.activity;
    }

    public FragmentTransaction beginTransaction() {
        return new TestFragmentTransaction(this);
    }

    public boolean executePendingTransactions() {
        return false;
    }

    public Fragment findFragmentById(int id) {
        return this.fragmentsById.get(id);
    }

    public Fragment findFragmentByTag(String tag) {
        return this.fragmentsByTag.get(tag);
    }

    public void popBackStack() {
    }

    public boolean popBackStackImmediate() {
        return false;
    }

    public void popBackStack(String name, int flags) {
    }

    public boolean popBackStackImmediate(String name, int flags) {
        return false;
    }

    public void popBackStack(int id, int flags) {
    }

    public boolean popBackStackImmediate(int id, int flags) {
        return false;
    }

    public int getBackStackEntryCount() {
        return 0;
    }

    public FragmentManager.BackStackEntry getBackStackEntryAt(int index) {
        return null;
    }

    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
    }

    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener listener) {
    }

    public void putFragment(Bundle bundle, String key, Fragment fragment) {
    }

    public Fragment getFragment(Bundle bundle, String key) {
        Object[] fragments;
        for (Object object : fragments = (Object[])bundle.getSerializable("android:fragments")) {
            SerializedFragmentState fragment = (SerializedFragmentState)object;
            if (!fragment.tag.equals(key)) continue;
            return Robolectric.newInstanceOf(fragment.fragmentClass);
        }
        return null;
    }

    public Fragment.SavedState saveFragmentInstanceState(Fragment f) {
        return null;
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    public void addDialogFragment(String tag, DialogFragment fragment) {
        this.fragmentsByTag.put(tag, (Fragment)fragment);
    }

    public void addFragment(int containerViewId, String tag, Fragment fragment, boolean replace) {
        this.fragmentsById.put(containerViewId, fragment);
        this.fragmentsByTag.put(tag, fragment);
        Robolectric.shadowOf(fragment).setTag(tag);
        Robolectric.shadowOf(fragment).setContainerViewId(containerViewId);
        Robolectric.shadowOf(fragment).setShouldReplace(replace);
        Robolectric.shadowOf(fragment).setActivity(this.activity);
        fragment.onAttach((Activity)this.activity);
        fragment.onCreate(null);
    }

    public void startFragment(Fragment fragment) {
        ViewGroup container = null;
        ShadowFragment shadowFragment = Robolectric.shadowOf(fragment);
        if (Robolectric.shadowOf(this.activity).getContentView() != null) {
            container = (ViewGroup)this.activity.findViewById(shadowFragment.getContainerViewId());
        }
        View view = fragment.onCreateView(this.activity.getLayoutInflater(), container, shadowFragment.getSavedInstanceState());
        shadowFragment.setView(view);
        fragment.onViewCreated(view, null);
        if (container != null) {
            if (shadowFragment.getShouldReplace()) {
                container.removeAllViews();
            }
            container.addView(view);
        }
        fragment.onActivityCreated(shadowFragment.getSavedInstanceState());
        fragment.onStart();
    }

    public HashMap<Integer, Fragment> getFragments() {
        return new HashMap<Integer, Fragment>(this.fragmentsById);
    }
}

