/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseConfig {
    private static DatabaseMap dbMap = null;
    private static boolean isLoaded = false;

    public static void setDatabaseMap(DatabaseMap map) {
        dbMap = map;
        isLoaded = false;
    }

    public static DatabaseMap getDatabaseMap() {
        return dbMap;
    }

    public static boolean isMapLoaded() {
        return isLoaded;
    }

    public static boolean isMapNull() {
        return dbMap == null;
    }

    private static void LoadSQLiteDriver() {
        if (DatabaseConfig.isMapNull()) {
            throw new NullDatabaseMapException("Error in DatabaseConfig: DatabaseMap has not been set.");
        }
        try {
            Class.forName(dbMap.getDriverClassName()).newInstance();
        }
        catch (InstantiationException e) {
            throw new CannotLoadDatabaseMapDriverException("Error in DatabaseConfig: SQLite driver could not be instantiated;", e);
        }
        catch (IllegalAccessException e) {
            throw new CannotLoadDatabaseMapDriverException("Error in DatabaseConfig: SQLite driver could not be accessed;", e);
        }
        catch (ClassNotFoundException e) {
            throw new CannotLoadDatabaseMapDriverException("Error in DatabaseConfig: SQLite driver class could not be found;", e);
        }
        isLoaded = true;
    }

    public static Connection getMemoryConnection() {
        if (!DatabaseConfig.isMapLoaded()) {
            DatabaseConfig.LoadSQLiteDriver();
        }
        try {
            return DriverManager.getConnection(dbMap.getConnectionString());
        }
        catch (SQLException e) {
            throw new CannotLoadDatabaseMapDriverException("Error in DatabaseConfig, could not retrieve connection to in memory database.", e);
        }
    }

    public static String getScrubSQL(String sql) throws SQLException {
        if (DatabaseConfig.isMapNull()) {
            throw new NullDatabaseMapException("No database map set!");
        }
        return dbMap.getScrubSQL(sql);
    }

    public static String getSelectLastInsertIdentity() {
        if (DatabaseConfig.isMapNull()) {
            throw new NullDatabaseMapException("No database map set!");
        }
        return dbMap.getSelectLastInsertIdentity();
    }

    public static int getResultSetType() {
        if (DatabaseConfig.isMapNull()) {
            throw new NullDatabaseMapException("No database map set!");
        }
        return dbMap.getResultSetType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface UsingDatabaseMap {
        public Class<? extends DatabaseMap> value();
    }

    public static class CannotLoadDatabaseMapDriverException
    extends RuntimeException {
        private static final long serialVersionUID = 2614876121296128364L;

        public CannotLoadDatabaseMapDriverException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NullDatabaseMapException
    extends RuntimeException {
        private static final long serialVersionUID = -4580960157495617424L;

        public NullDatabaseMapException(String message) {
            super(message);
        }
    }

    public static interface DatabaseMap {
        public String getDriverClassName();

        public String getConnectionString();

        public String getScrubSQL(String var1) throws SQLException;

        public String getSelectLastInsertIdentity();

        public int getResultSetType();
    }
}

