/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.util;

import com.xtremelabs.robolectric.util.DatabaseConfig;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class H2Map
implements DatabaseConfig.DatabaseMap {
    @Override
    public String getDriverClassName() {
        return "org.h2.Driver";
    }

    @Override
    public String getConnectionString() {
        return "jdbc:h2:mem:";
    }

    @Override
    public String getScrubSQL(String sql) throws SQLException {
        if (sql.contains("PRIMARY KEY AUTOINCREMENT") && !sql.contains("INTEGER PRIMARY KEY AUTOINCREMENT")) {
            throw new SQLException("AUTOINCREMENT is only allowed on an INTEGER PRIMARY KEY");
        }
        String scrubbedSQL = sql.replaceAll("(?i:autoincrement)", "auto_increment");
        scrubbedSQL = scrubbedSQL.replaceAll("(?i:integer)", "bigint(19)");
        scrubbedSQL = scrubbedSQL.replaceAll("INSERT OR ROLLBACK INTO", "INSERT INTO");
        scrubbedSQL = scrubbedSQL.replaceAll("INSERT OR ABORT INTO", "INSERT INTO");
        scrubbedSQL = scrubbedSQL.replaceAll("INSERT OR FAIL INTO", "INSERT INTO");
        scrubbedSQL = scrubbedSQL.replaceAll("INSERT OR IGNORE INTO", "INSERT INTO");
        scrubbedSQL = scrubbedSQL.replaceAll("INSERT OR REPLACE INTO", "INSERT INTO");
        return scrubbedSQL;
    }

    @Override
    public String getSelectLastInsertIdentity() {
        return "SELECT IDENTITY();";
    }

    public void DeregisterDriver() {
        try {
            Driver d = DriverManager.getDriver(this.getDriverClassName());
            DriverManager.deregisterDriver(d);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.DeregisterDriver();
    }

    @Override
    public int getResultSetType() {
        return 1004;
    }
}

