/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.util;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import com.xtremelabs.robolectric.util.DatabaseConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLite {
    private static final String[] CONFLICT_VALUES = new String[]{"", "OR ROLLBACK ", "OR ABORT ", "OR FAIL ", "OR IGNORE ", "OR REPLACE "};

    public static SQLStringAndBindings buildInsertString(String table, ContentValues values, int conflictAlgorithm) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT ");
        sb.append(CONFLICT_VALUES[conflictAlgorithm]);
        sb.append("INTO ");
        sb.append(table);
        sb.append(" ");
        SQLStringAndBindings columnsValueClause = SQLite.buildColumnValuesClause(values);
        sb.append(columnsValueClause.sql);
        sb.append(";");
        String sql = DatabaseConfig.getScrubSQL(sb.toString());
        return new SQLStringAndBindings(sql, columnsValueClause.columnValues);
    }

    public static SQLStringAndBindings buildUpdateString(String table, ContentValues values, String whereClause, String[] whereArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(table);
        sb.append(" SET ");
        SQLStringAndBindings columnAssignmentsClause = SQLite.buildColumnAssignmentsClause(values);
        sb.append(columnAssignmentsClause.sql);
        if (whereClause != null) {
            String where = whereClause;
            if (whereArgs != null) {
                where = SQLite.buildWhereClause(whereClause, whereArgs);
            }
            sb.append(" WHERE ");
            sb.append(where);
        }
        sb.append(";");
        return new SQLStringAndBindings(sb.toString(), columnAssignmentsClause.columnValues);
    }

    public static String buildDeleteString(String table, String whereClause, String[] whereArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(table);
        if (whereClause != null) {
            String where = whereClause;
            if (whereArgs != null) {
                where = SQLite.buildWhereClause(whereClause, whereArgs);
            }
            sb.append(" WHERE ");
            sb.append(where);
        }
        sb.append(";");
        return sb.toString();
    }

    public static String buildWhereClause(String selection, String[] selectionArgs) throws SQLiteException {
        String whereClause = selection;
        int argsNeeded = 0;
        int args = 0;
        for (char c : selection.toCharArray()) {
            if (c != '?') continue;
            ++argsNeeded;
        }
        if (selectionArgs != null) {
            for (int x = 0; x < selectionArgs.length; ++x) {
                if (selectionArgs[x] == null) {
                    throw new IllegalArgumentException("the bind value at index " + x + " is null");
                }
                ++args;
                whereClause = whereClause.replaceFirst("\\?", "'" + selectionArgs[x] + "'");
            }
        }
        if (argsNeeded != args) {
            throw new SQLiteException("bind or column index out of range: count of selectionArgs does not match count of (?) placeholders for given sql statement!");
        }
        return whereClause;
    }

    public static SQLStringAndBindings buildColumnValuesClause(ContentValues values) {
        StringBuilder clause = new StringBuilder("(");
        ArrayList<Object> columnValues = new ArrayList<Object>(values.size());
        Iterator itemEntries = values.valueSet().iterator();
        while (itemEntries.hasNext()) {
            Map.Entry entry = (Map.Entry)itemEntries.next();
            clause.append((String)entry.getKey());
            if (itemEntries.hasNext()) {
                clause.append(", ");
            }
            columnValues.add(entry.getValue());
        }
        clause.append(") VALUES (");
        for (int i = 0; i < values.size() - 1; ++i) {
            clause.append("?, ");
        }
        clause.append("?)");
        return new SQLStringAndBindings(clause.toString(), columnValues);
    }

    public static SQLStringAndBindings buildColumnAssignmentsClause(ContentValues values) {
        StringBuilder clause = new StringBuilder();
        ArrayList<Object> columnValues = new ArrayList<Object>(values.size());
        Iterator itemsEntries = values.valueSet().iterator();
        while (itemsEntries.hasNext()) {
            Map.Entry entry = (Map.Entry)itemsEntries.next();
            clause.append((String)entry.getKey());
            clause.append("=?");
            if (itemsEntries.hasNext()) {
                clause.append(", ");
            }
            columnValues.add(entry.getValue());
        }
        return new SQLStringAndBindings(clause.toString(), columnValues);
    }

    public static class SQLStringAndBindings {
        public String sql;
        public List<Object> columnValues;

        public SQLStringAndBindings(String sql, List<Object> columnValues) {
            this.sql = sql;
            this.columnValues = columnValues;
        }
    }
}

