/*
 * Decompiled with CFR 0.152.
 */
package com.xtremelabs.robolectric.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Scheduler {
    private List<PostedRunnable> postedRunnables = new ArrayList<PostedRunnable>();
    private long currentTime = 0L;
    private boolean paused = false;

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void pause() {
        this.paused = true;
    }

    public void unPause() {
        this.paused = false;
        this.advanceToLastPostedRunnable();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void postDelayed(Runnable runnable, long delayMillis) {
        if (this.paused || delayMillis > 0L) {
            this.postedRunnables.add(new PostedRunnable(runnable, this.currentTime + delayMillis));
            Collections.sort(this.postedRunnables);
        } else {
            runnable.run();
        }
    }

    public void post(Runnable runnable) {
        this.postDelayed(runnable, 0L);
    }

    public void postAtFrontOfQueue(Runnable runnable) {
        if (this.paused) {
            this.postedRunnables.add(0, new PostedRunnable(runnable, this.currentTime));
        } else {
            runnable.run();
        }
    }

    public void remove(Runnable runnable) {
        ListIterator<PostedRunnable> iterator = this.postedRunnables.listIterator();
        while (iterator.hasNext()) {
            PostedRunnable next = iterator.next();
            if (next.runnable != runnable) continue;
            iterator.remove();
        }
    }

    public boolean advanceToLastPostedRunnable() {
        if (this.enqueuedTaskCount() < 1) {
            return false;
        }
        return this.advanceTo(this.postedRunnables.get((int)(this.postedRunnables.size() - 1)).scheduledTime);
    }

    public boolean advanceToNextPostedRunnable() {
        if (this.enqueuedTaskCount() < 1) {
            return false;
        }
        return this.advanceTo(this.postedRunnables.get((int)0).scheduledTime);
    }

    public boolean advanceBy(long intervalMs) {
        long endingTime = this.currentTime + intervalMs;
        return this.advanceTo(endingTime);
    }

    public boolean advanceTo(long endingTime) {
        if (endingTime - this.currentTime < 0L || this.enqueuedTaskCount() < 1) {
            return false;
        }
        int runCount = 0;
        while (this.nextTaskIsScheduledBefore(endingTime)) {
            this.runOneTask();
            ++runCount;
        }
        this.currentTime = endingTime;
        return runCount > 0;
    }

    public boolean runOneTask() {
        if (this.enqueuedTaskCount() < 1) {
            return false;
        }
        PostedRunnable postedRunnable = this.postedRunnables.remove(0);
        this.currentTime = postedRunnable.scheduledTime;
        postedRunnable.run();
        return true;
    }

    public boolean runTasks(int howMany) {
        if (this.enqueuedTaskCount() < howMany) {
            return false;
        }
        while (howMany > 0) {
            PostedRunnable postedRunnable = this.postedRunnables.remove(0);
            this.currentTime = postedRunnable.scheduledTime;
            postedRunnable.run();
            --howMany;
        }
        return true;
    }

    public int enqueuedTaskCount() {
        return this.postedRunnables.size();
    }

    public boolean areAnyRunnable() {
        return this.nextTaskIsScheduledBefore(this.currentTime);
    }

    public void reset() {
        this.postedRunnables.clear();
        this.paused = false;
    }

    public int size() {
        return this.postedRunnables.size();
    }

    private boolean nextTaskIsScheduledBefore(long endingTime) {
        return this.enqueuedTaskCount() > 0 && this.postedRunnables.get((int)0).scheduledTime <= endingTime;
    }

    class PostedRunnable
    implements Comparable<PostedRunnable> {
        Runnable runnable;
        long scheduledTime;

        PostedRunnable(Runnable runnable, long scheduledTime) {
            this.runnable = runnable;
            this.scheduledTime = scheduledTime;
        }

        @Override
        public int compareTo(PostedRunnable postedRunnable) {
            return (int)(this.scheduledTime - postedRunnable.scheduledTime);
        }

        public void run() {
            this.runnable.run();
        }
    }
}

