/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb;

import com.rethinkdb.RethinkDBException;
import com.rethinkdb.SocketChannelFacade;
import com.rethinkdb.proto.Q2L;
import com.rethinkdb.response.DBResultFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RethinkDBConnection {
    private static final Logger logger = LoggerFactory.getLogger(RethinkDBConnection.class);
    private static final AtomicInteger tokenGenerator = new AtomicInteger();
    private String hostname;
    private String authKey;
    private int port;
    private int timeout;
    private String dbName = null;
    private SocketChannelFacade socket = new SocketChannelFacade();
    private Q2L.Query dbOption;

    public RethinkDBConnection() {
        this("localhost");
    }

    public RethinkDBConnection(String hostname) {
        this(hostname, 28015);
    }

    public RethinkDBConnection(String hostname, int port) {
        this(hostname, port, "");
    }

    public RethinkDBConnection(String hostname, int port, String authKey) {
        this(hostname, port, authKey, 20);
    }

    public RethinkDBConnection(String hostname, int port, String authKey, int timeout) {
        this.hostname = hostname;
        this.port = port;
        this.authKey = authKey;
        this.timeout = timeout;
        this.reconnect();
    }

    public void reconnect() {
        this.socket.connect(this.hostname, this.port);
        this.socket.writeLEInt(Q2L.VersionDummy.Version.V0_2.getNumber());
        this.socket.writeStringWithLength(this.authKey);
        String result = this.socket.readString();
        if (!result.startsWith("SUCCESS")) {
            throw new RethinkDBException(result);
        }
    }

    public void close() {
        this.socket.close();
    }

    public void use(String dbName) {
        this.dbName = dbName;
    }

    public <T> T run(Q2L.Term term) {
        Q2L.Query.Builder queryBuilder = Q2L.Query.newBuilder().setToken(tokenGenerator.incrementAndGet()).setType(Q2L.Query.QueryType.START).setQuery(term);
        this.setDbOptionIfNeeded(queryBuilder, this.dbName);
        logger.debug("running {} ", (Object)queryBuilder.build());
        this.socket.write(queryBuilder.build().toByteArray());
        Q2L.Response response = this.socket.read();
        return DBResultFactory.convert(response);
    }

    private void setDbOptionIfNeeded(Q2L.Query.Builder q, String db) {
        if (db == null) {
            return;
        }
        if (!this.hasDBSet(q)) {
            q.addGlobalOptargs(Q2L.Query.AssocPair.newBuilder().setKey("db").setVal(Q2L.Term.newBuilder().setType(Q2L.Term.TermType.DB).addArgs(Q2L.Term.newBuilder().setType(Q2L.Term.TermType.DATUM).setDatum(Q2L.Datum.newBuilder().setType(Q2L.Datum.DatumType.R_STR).setRStr(db).build())).build()));
        }
    }

    private boolean hasDBSet(Q2L.Query.Builder q) {
        for (Q2L.Query.AssocPair assocPair : q.getGlobalOptargsList()) {
            if (!assocPair.getKey().equals("db")) continue;
            return true;
        }
        return false;
    }
}

