/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb;

import com.google.protobuf.InvalidProtocolBufferException;
import com.rethinkdb.RethinkDBException;
import com.rethinkdb.proto.Q2L;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class SocketChannelFacade {
    private SocketChannel socketChannel;

    public void connect(String hostname, int port) {
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(true);
            this.socketChannel.connect(new InetSocketAddress(hostname, port));
        }
        catch (IOException e) {
            throw new RethinkDBException(e);
        }
    }

    private void _write(ByteBuffer buffer) {
        try {
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.socketChannel.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RethinkDBException(e);
        }
    }

    private ByteBuffer _read(int i, boolean strict) {
        ByteBuffer buffer = ByteBuffer.allocate(i);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            int read = this.socketChannel.read(buffer);
            if (read != i && strict) {
                throw new RethinkDBException("Error receiving data, expected " + i + " bytes but received " + read);
            }
            buffer.flip();
            return buffer;
        }
        catch (IOException e) {
            throw new RethinkDBException(e);
        }
    }

    public void writeLEInt(int i) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(i);
        this._write(buffer);
    }

    public int readLEInt() {
        ByteBuffer buffer = this._read(4, true);
        return buffer.getInt();
    }

    public void writeStringWithLength(String s) {
        this.writeLEInt(s.length());
        ByteBuffer buffer = ByteBuffer.allocate(s.length());
        buffer.put(s.getBytes());
        this._write(buffer);
    }

    public String readString() {
        return new String(this._read(5000, false).array());
    }

    public void write(byte[] bytes) {
        this.writeLEInt(bytes.length);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        this._write(buffer);
    }

    public Q2L.Response read() {
        try {
            int len = this.readLEInt();
            ByteBuffer buffer = this._read(len, true);
            return Q2L.Response.parseFrom(buffer.array());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RethinkDBException(e);
        }
    }

    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            throw new RethinkDBException(e);
        }
    }
}

