/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast.query;

import com.google.common.collect.Lists;
import com.rethinkdb.RethinkDBConnection;
import com.rethinkdb.ast.helper.Arguments;
import com.rethinkdb.ast.helper.OptionalArguments;
import com.rethinkdb.ast.query.RqlUtil;
import com.rethinkdb.ast.query.gen.Add;
import com.rethinkdb.ast.query.gen.All;
import com.rethinkdb.ast.query.gen.Any;
import com.rethinkdb.ast.query.gen.Append;
import com.rethinkdb.ast.query.gen.Asc;
import com.rethinkdb.ast.query.gen.Avg;
import com.rethinkdb.ast.query.gen.Branch;
import com.rethinkdb.ast.query.gen.ChangeAt;
import com.rethinkdb.ast.query.gen.ConcatMap;
import com.rethinkdb.ast.query.gen.Contains;
import com.rethinkdb.ast.query.gen.Count;
import com.rethinkdb.ast.query.gen.DB;
import com.rethinkdb.ast.query.gen.Date;
import com.rethinkdb.ast.query.gen.Day;
import com.rethinkdb.ast.query.gen.DayOfWeek;
import com.rethinkdb.ast.query.gen.DayOfYear;
import com.rethinkdb.ast.query.gen.DbCreate;
import com.rethinkdb.ast.query.gen.DbDrop;
import com.rethinkdb.ast.query.gen.DbList;
import com.rethinkdb.ast.query.gen.Delete;
import com.rethinkdb.ast.query.gen.DeleteAt;
import com.rethinkdb.ast.query.gen.Desc;
import com.rethinkdb.ast.query.gen.Difference;
import com.rethinkdb.ast.query.gen.Distinct;
import com.rethinkdb.ast.query.gen.Div;
import com.rethinkdb.ast.query.gen.Downcase;
import com.rethinkdb.ast.query.gen.During;
import com.rethinkdb.ast.query.gen.EpochTime;
import com.rethinkdb.ast.query.gen.Eq;
import com.rethinkdb.ast.query.gen.EqJoin;
import com.rethinkdb.ast.query.gen.Filter;
import com.rethinkdb.ast.query.gen.Func;
import com.rethinkdb.ast.query.gen.Ge;
import com.rethinkdb.ast.query.gen.Get;
import com.rethinkdb.ast.query.gen.GetAll;
import com.rethinkdb.ast.query.gen.GetField;
import com.rethinkdb.ast.query.gen.Group;
import com.rethinkdb.ast.query.gen.Gt;
import com.rethinkdb.ast.query.gen.HasFields;
import com.rethinkdb.ast.query.gen.Hours;
import com.rethinkdb.ast.query.gen.ISO8601;
import com.rethinkdb.ast.query.gen.ImplicitVar;
import com.rethinkdb.ast.query.gen.InTimezone;
import com.rethinkdb.ast.query.gen.IndexesOf;
import com.rethinkdb.ast.query.gen.InnerJoin;
import com.rethinkdb.ast.query.gen.InsertAt;
import com.rethinkdb.ast.query.gen.IsEmpty;
import com.rethinkdb.ast.query.gen.Keys;
import com.rethinkdb.ast.query.gen.Le;
import com.rethinkdb.ast.query.gen.Limit;
import com.rethinkdb.ast.query.gen.Lt;
import com.rethinkdb.ast.query.gen.Match;
import com.rethinkdb.ast.query.gen.Max;
import com.rethinkdb.ast.query.gen.Min;
import com.rethinkdb.ast.query.gen.Minutes;
import com.rethinkdb.ast.query.gen.Mod;
import com.rethinkdb.ast.query.gen.Month;
import com.rethinkdb.ast.query.gen.Mul;
import com.rethinkdb.ast.query.gen.Ne;
import com.rethinkdb.ast.query.gen.Not;
import com.rethinkdb.ast.query.gen.Now;
import com.rethinkdb.ast.query.gen.OrderBy;
import com.rethinkdb.ast.query.gen.OuterJoin;
import com.rethinkdb.ast.query.gen.Pluck;
import com.rethinkdb.ast.query.gen.Prepend;
import com.rethinkdb.ast.query.gen.RMap;
import com.rethinkdb.ast.query.gen.Reduce;
import com.rethinkdb.ast.query.gen.Replace;
import com.rethinkdb.ast.query.gen.Sample;
import com.rethinkdb.ast.query.gen.Seconds;
import com.rethinkdb.ast.query.gen.SetDifference;
import com.rethinkdb.ast.query.gen.SetInsert;
import com.rethinkdb.ast.query.gen.SetIntersection;
import com.rethinkdb.ast.query.gen.SetUnion;
import com.rethinkdb.ast.query.gen.Skip;
import com.rethinkdb.ast.query.gen.SpliceAt;
import com.rethinkdb.ast.query.gen.Split;
import com.rethinkdb.ast.query.gen.Sub;
import com.rethinkdb.ast.query.gen.Sum;
import com.rethinkdb.ast.query.gen.Sync;
import com.rethinkdb.ast.query.gen.Table;
import com.rethinkdb.ast.query.gen.Time;
import com.rethinkdb.ast.query.gen.TimeOfDay;
import com.rethinkdb.ast.query.gen.Timezone;
import com.rethinkdb.ast.query.gen.ToEpochTime;
import com.rethinkdb.ast.query.gen.ToISO8601;
import com.rethinkdb.ast.query.gen.Ungroup;
import com.rethinkdb.ast.query.gen.Union;
import com.rethinkdb.ast.query.gen.Upcase;
import com.rethinkdb.ast.query.gen.Update;
import com.rethinkdb.ast.query.gen.WithFields;
import com.rethinkdb.ast.query.gen.Without;
import com.rethinkdb.ast.query.gen.Year;
import com.rethinkdb.ast.query.gen.Zip;
import com.rethinkdb.model.Durability;
import com.rethinkdb.model.RqlFunction;
import com.rethinkdb.model.RqlFunction2;
import com.rethinkdb.proto.Q2L;
import com.rethinkdb.response.GroupedResponseConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RqlQuery {
    public static RqlQuery R = new RqlQuery(null, null);
    private Q2L.Term.TermType termType;
    protected List<RqlQuery> args = new ArrayList<RqlQuery>();
    protected Map<String, RqlQuery> optionalArgs = new HashMap<String, RqlQuery>();

    protected RqlQuery(Q2L.Term.TermType termType, List<Object> args) {
        this(termType, args, new HashMap<String, Object>());
    }

    protected RqlQuery(Q2L.Term.TermType termType) {
        this(termType, new ArrayList<Object>(), new HashMap<String, Object>());
    }

    protected RqlQuery(Q2L.Term.TermType termType, List<Object> args, Map<String, Object> optionalArgs) {
        this(null, termType, args, optionalArgs);
    }

    public RqlQuery(RqlQuery previous, Q2L.Term.TermType termType, List<Object> args, Map<String, Object> optionalArgs) {
        this.termType = termType;
        this.init(previous, args, optionalArgs);
    }

    protected void init(RqlQuery previous, List<Object> args, Map<String, Object> optionalArgs) {
        if (previous != null && previous.termType != null) {
            this.args.add(previous);
        }
        if (args != null) {
            for (Object object : args) {
                this.args.add(RqlUtil.toRqlQuery(object));
            }
        }
        if (optionalArgs != null) {
            for (Map.Entry entry : optionalArgs.entrySet()) {
                this.optionalArgs.put((String)entry.getKey(), RqlUtil.toRqlQuery(entry.getValue()));
            }
        }
    }

    protected Q2L.Term.TermType getTermType() {
        return this.termType;
    }

    protected List<RqlQuery> getArgs() {
        return this.args;
    }

    protected Map<String, RqlQuery> getOptionalArgs() {
        return this.optionalArgs;
    }

    protected Q2L.Term toTerm() {
        Q2L.Term.Builder termBuilder = Q2L.Term.newBuilder().setType(this.termType);
        for (RqlQuery rqlQuery : this.args) {
            termBuilder.addArgs(rqlQuery.toTerm());
        }
        for (Map.Entry entry : this.optionalArgs.entrySet()) {
            termBuilder.addOptargs(Q2L.Term.AssocPair.newBuilder().setKey((String)entry.getKey()).setVal(((RqlQuery)entry.getValue()).toTerm())).build();
        }
        return termBuilder.build();
    }

    public Object run(RethinkDBConnection connection) {
        return connection.run(this.toTerm());
    }

    public <K, V> Map<K, V> runForGroup(RethinkDBConnection connection) {
        return GroupedResponseConverter.convert((Map)this.run(connection));
    }

    public DbCreate dbCreate(String dbName) {
        return new DbCreate(new Arguments((Object)dbName), null);
    }

    public DbDrop dbDrop(String dbName) {
        return new DbDrop(new Arguments((Object)dbName), null);
    }

    public DbList dbList() {
        return new DbList(null, null);
    }

    public RqlQuery eq(Object ... queries) {
        return new Eq(this, Arrays.asList(queries), null);
    }

    public RqlQuery ne(Object ... queries) {
        return new Ne(this, Arrays.asList(queries), null);
    }

    public RqlQuery lt(Object ... queries) {
        return new Lt(this, Arrays.asList(queries), null);
    }

    public RqlQuery le(Object ... queries) {
        return new Le(this, Arrays.asList(queries), null);
    }

    public RqlQuery gt(Object ... queries) {
        return new Gt(this, Arrays.asList(queries), null);
    }

    public RqlQuery ge(Object ... queries) {
        return new Ge(this, Arrays.asList(queries), null);
    }

    public RqlQuery add(Object ... queries) {
        return new Add(this, Arrays.asList(queries), null);
    }

    public RqlQuery sub(Object ... queries) {
        return new Sub(this, Arrays.asList(queries), null);
    }

    public RqlQuery mul(Object ... queries) {
        return new Mul(this, Arrays.asList(queries), null);
    }

    public RqlQuery div(Object ... queries) {
        return new Div(this, Arrays.asList(queries), null);
    }

    public RqlQuery mod(Object ... queries) {
        return new Mod(this, Arrays.asList(queries), null);
    }

    public RqlQuery and(Object ... queries) {
        return new All(this, Arrays.asList(queries), null);
    }

    public RqlQuery or(Object ... queries) {
        return new Any(this, Arrays.asList(queries), null);
    }

    public RqlQuery not(Object ... queries) {
        return new Not(this, Arrays.asList(queries), null);
    }

    public DB db(String db) {
        return new DB(new Arguments((Object)db), null);
    }

    public Update update(Map<String, Object> object, Boolean nonAtomic, Durability durability, Boolean returnVals) {
        return new Update(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(object)), (Map<String, Object>)new OptionalArguments().with("non_atomic", nonAtomic).with("durability", (Object)durability).with("return_vals", returnVals));
    }

    public Update update(Map<String, Object> object) {
        return this.update(object, null, null, null);
    }

    public Update update(RqlFunction function, Boolean nonAtomic, Durability durability, Boolean returnVals) {
        return new Update(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(function)), (Map<String, Object>)new OptionalArguments().with("non_atomic", nonAtomic).with("durability", (Object)durability).with("return_vals", returnVals));
    }

    public Update update(RqlFunction function) {
        return this.update(function, null, null, null);
    }

    public ImplicitVar row() {
        return new ImplicitVar(null, null, null);
    }

    public GetField field(String field) {
        return new GetField(this, (List<Object>)new Arguments((Object)field), null);
    }

    public RMap map(RqlFunction function) {
        return new RMap(this, (List<Object>)new Arguments((Object)new Func(function)), null);
    }

    public ConcatMap concatMap(RqlFunction function) {
        return new ConcatMap(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(function)), null);
    }

    public OrderBy orderBy(RqlFunction function) {
        return this.orderBy(null, function);
    }

    public OrderBy orderBy(List<Object> fields, String index) {
        return this.orderBy(index, fields);
    }

    public OrderBy orderBy(Object ... fields) {
        return this.orderBy(null, fields);
    }

    public OrderBy orderByIndex(String index) {
        return this.orderBy(index, null);
    }

    public OrderBy orderByField(String field) {
        return this.orderBy((String)null, field);
    }

    private OrderBy orderBy(String index, Object ... fields) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object field : fields) {
            if (field instanceof Asc || field instanceof Desc) {
                args.add(field);
                continue;
            }
            args.add(RqlUtil.funcWrap(field));
        }
        return new OrderBy(this, (List<Object>)new Arguments((List<Object>)args), (Map<String, Object>)new OptionalArguments().with("index", index));
    }

    public Get get(String key) {
        return new Get(this, (List<Object>)new Arguments((Object)key), null);
    }

    public GetAll get(List<String> keys) {
        return this.get(keys, null);
    }

    public GetAll get(List<String> keys, String index) {
        return new GetAll(this, (List<Object>)new Arguments((Object)keys), (Map<String, Object>)new OptionalArguments().with("index", index));
    }

    public Filter filter(RqlFunction function) {
        return new Filter(this, (List<Object>)new Arguments((Object)new Func(function)), null);
    }

    public Filter filter(RqlQuery query) {
        return new Filter(this, (List<Object>)new Arguments((Object)query), null);
    }

    public Table table(String tableName) {
        return new Table(this, (List<Object>)new Arguments((Object)tableName), null);
    }

    public Upcase upcase() {
        return new Upcase(this, null, null);
    }

    public Downcase downcase() {
        return new Downcase(this, null, null);
    }

    public Split split(String s) {
        return new Split(this, (List<Object>)new Arguments((Object)s), null);
    }

    public Replace replace(Map<String, Object> replacement) {
        return new Replace(this, (List<Object>)new Arguments((Object)replacement), null);
    }

    public Replace replace(RqlFunction function) {
        return new Replace(this, (List<Object>)new Arguments((Object)new Func(function)), null);
    }

    public RqlQuery without(String ... fields) {
        return this.without(Lists.newArrayList((Object[])fields));
    }

    public RqlQuery without(List<String> field) {
        return new Without(this, (List<Object>)new Arguments((Object)field), null);
    }

    public Pluck pluck(String ... fields) {
        return this.pluck(Lists.newArrayList((Object[])fields));
    }

    public Pluck pluck(List<String> fields) {
        return new Pluck(this, (List<Object>)new Arguments((Object)fields), null);
    }

    public Branch branch(RqlQuery predicate, Map<String, Object> trueBranch, Map<String, Object> falseBranch) {
        return new Branch(predicate, (List<Object>)new Arguments(trueBranch, falseBranch), null);
    }

    public Append append(Object t) {
        return new Append(this, (List<Object>)new Arguments(t), null);
    }

    public Prepend prepend(Object t) {
        return new Prepend(this, (List<Object>)new Arguments(t), null);
    }

    public Difference difference(List<Object> ts) {
        return new Difference(this, (List<Object>)new Arguments(ts), null);
    }

    public Delete delete() {
        return this.delete(null, null);
    }

    public Delete delete(Durability durability, Boolean withVals) {
        return new Delete(this, null, (Map<String, Object>)new OptionalArguments().with("durability", (Object)durability).with("with_vals", withVals));
    }

    public Count count() {
        return new Count(this, null, null);
    }

    public Sync sync() {
        return new Sync(this, null, null);
    }

    public Match match(String regexp) {
        return new Match(this, (List<Object>)new Arguments((Object)regexp), null);
    }

    public RqlQuery expr(Object expr) {
        return RqlUtil.toRqlQuery(expr);
    }

    public WithFields withFields(String ... fields) {
        return new WithFields(this, (List<Object>)new Arguments(fields), null);
    }

    public InnerJoin innerJoin(RqlQuery other, RqlFunction2 predicate) {
        return new InnerJoin(this, (List<Object>)new Arguments(other, RqlUtil.funcWrap(predicate)), null);
    }

    public OuterJoin outerJoin(RqlQuery other, RqlFunction2 predicate) {
        return new OuterJoin(this, (List<Object>)new Arguments(other, RqlUtil.funcWrap(predicate)), null);
    }

    public EqJoin eqJoin(String leftAttribute, Table otherTable) {
        return this.eqJoin(leftAttribute, otherTable, null);
    }

    public EqJoin eqJoin(String leftAttribute, Table otherTable, String indexId) {
        return new EqJoin(this, (List<Object>)new Arguments(leftAttribute, otherTable), (Map<String, Object>)new OptionalArguments().with("index", indexId));
    }

    public EqJoin eqJoin(RqlFunction leftAttribute, Table otherTable) {
        return this.eqJoin(leftAttribute, otherTable, null);
    }

    public EqJoin eqJoin(RqlFunction leftAttribute, Table otherTable, String indexId) {
        return new EqJoin(this, (List<Object>)new Arguments(RqlUtil.funcWrap(leftAttribute), otherTable), (Map<String, Object>)new OptionalArguments().with("index", indexId));
    }

    public Zip zip() {
        return new Zip(this, null, null);
    }

    public Desc desc(String key) {
        return new Desc(this, (List<Object>)new Arguments((Object)key), null);
    }

    public Asc asc(String key) {
        return new Asc(this, (List<Object>)new Arguments((Object)key), null);
    }

    public Skip skip(int n) {
        return new Skip(this, (List<Object>)new Arguments((Object)n), null);
    }

    public Limit limit(int n) {
        return new Limit(this, (List<Object>)new Arguments((Object)n), null);
    }

    public IndexesOf indexesOf(Object value) {
        return new IndexesOf(this, (List<Object>)new Arguments(value), null);
    }

    public IndexesOf indexesOf(RqlQuery predicate) {
        return new IndexesOf(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(predicate)), null);
    }

    public IsEmpty isEmpty() {
        return new IsEmpty(this, null, null);
    }

    public Union union(RqlQuery other) {
        return new Union(this, (List<Object>)new Arguments((Object)other), null);
    }

    public Sample sample(int size) {
        return new Sample(this, (List<Object>)new Arguments((Object)size), null);
    }

    public Max max(String field) {
        return new Max(this, (List<Object>)new Arguments((Object)field), null);
    }

    public Max max(RqlFunction func) {
        return new Max(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(func)), null);
    }

    public Min min(String field) {
        return new Min(this, (List<Object>)new Arguments((Object)field), null);
    }

    public Min min(RqlFunction func) {
        return new Min(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(func)), null);
    }

    public Group group(RqlFunction func) {
        return this.group(func, null);
    }

    public Group group(RqlFunction func, String index) {
        return new Group(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(func)), (Map<String, Object>)new OptionalArguments().with("index", index));
    }

    public Group group(String field) {
        return this.group(field, null);
    }

    public Group group(String field, List index) {
        return new Group(this, (List<Object>)new Arguments((Object)field), (Map<String, Object>)new OptionalArguments().with("index", index));
    }

    public Ungroup ungroup() {
        return new Ungroup(this, null, null);
    }

    public Reduce reduce(RqlFunction2 func) {
        return new Reduce(this, (List<Object>)new Arguments((Object)RqlUtil.funcWrap(func)), null);
    }

    public Sum sum() {
        return new Sum(this, null, null);
    }

    public Avg avg() {
        return new Avg(this, null, null);
    }

    public Min min() {
        return new Min(this, null, null);
    }

    public Max max() {
        return new Max(this, null, null);
    }

    public Distinct distinct() {
        return new Distinct(this, null, null);
    }

    public Contains contains(List<Object> objects) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object object : objects) {
            args.add(RqlUtil.funcWrap(object));
        }
        return new Contains(this, args, null);
    }

    public SetInsert setInsert(List<Object> objects) {
        return new SetInsert(this, (List<Object>)new Arguments(objects), null);
    }

    public SetUnion setUnion(List<Object> objects) {
        return new SetUnion(this, (List<Object>)new Arguments(objects), null);
    }

    public SetIntersection setIntersection(List<Object> objects) {
        return new SetIntersection(this, (List<Object>)new Arguments(objects), null);
    }

    public SetDifference setDifference(List<Object> objects) {
        return new SetDifference(this, (List<Object>)new Arguments(objects), null);
    }

    public HasFields hasFields(List<String> fields) {
        return new HasFields(this, (List<Object>)new Arguments((Object)fields), null);
    }

    public InsertAt insertAt(int index, Object value) {
        return new InsertAt(this, (List<Object>)new Arguments(index, value), null);
    }

    public SpliceAt spliceAt(int index, List<Object> values) {
        return new SpliceAt(this, (List<Object>)new Arguments(index, values), null);
    }

    public DeleteAt deleteAt(int index) {
        return new DeleteAt(this, (List<Object>)new Arguments((Object)index), null);
    }

    public DeleteAt deleteAt(int index, int endIndex) {
        return new DeleteAt(this, (List<Object>)new Arguments(index, endIndex), null);
    }

    public ChangeAt changeAt(int index, Object value) {
        return new ChangeAt(this, (List<Object>)new Arguments(index, value), null);
    }

    public Keys keys() {
        return new Keys(this, null, null);
    }

    public Now now() {
        return new Now(this, null, null);
    }

    public Date date() {
        return new Date(this, null, null);
    }

    public Time time(int year, int month, int day) {
        return this.time(year, month, day, "Z");
    }

    public Time time(int year, int month, int day, String timezone) {
        return new Time(this, (List<Object>)new Arguments(year, month, day, timezone), null);
    }

    public Time time(int year, int month, int day, int hour, int minute, int second) {
        return this.time(year, month, day, hour, minute, second);
    }

    public Time time(int year, int month, int day, int hour, int minute, int second, String timezone) {
        return new Time(this, (List<Object>)new Arguments(year, month, day, hour, minute, second, timezone), null);
    }

    public EpochTime epochTime(long time) {
        return new EpochTime(this, (List<Object>)new Arguments((Object)time), null);
    }

    public ISO8601 ISO8601(String iso) {
        return new ISO8601(this, (List<Object>)new Arguments((Object)iso), null);
    }

    public InTimezone inTimezone(String tz) {
        return new InTimezone(this, (List<Object>)new Arguments((Object)tz), null);
    }

    public Timezone timezone(String tz) {
        return new Timezone(this, (List<Object>)new Arguments((Object)tz), null);
    }

    public During during(RqlQuery left, RqlQuery right, boolean leftInclusive, boolean rightInclusive) {
        return new During(this, (List<Object>)new Arguments(left, right), (Map<String, Object>)new OptionalArguments().with("left_bound", !leftInclusive ? "open" : "closed").with("right_bound", !rightInclusive ? "open" : "closed"));
    }

    public TimeOfDay timeOfDay() {
        return new TimeOfDay(this, null, null);
    }

    public Year year() {
        return new Year(this, null, null);
    }

    public Month month() {
        return new Month(this, null, null);
    }

    public Day day() {
        return new Day(this, null, null);
    }

    public DayOfWeek dayOfWeek() {
        return new DayOfWeek(this, null, null);
    }

    public DayOfYear dayOfYear() {
        return new DayOfYear(this, null, null);
    }

    public Hours hours() {
        return new Hours(this, null, null);
    }

    public Minutes minutes() {
        return new Minutes(this, null, null);
    }

    public Seconds seconds() {
        return new Seconds(this, null, null);
    }

    public ToISO8601 toISO8601() {
        return new ToISO8601(this, null, null);
    }

    public ToEpochTime toEpochTime() {
        return new ToEpochTime(this, null, null);
    }
}

