/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast.query;

import com.rethinkdb.RethinkDB;
import com.rethinkdb.RethinkDBException;
import com.rethinkdb.ast.query.RqlQuery;
import com.rethinkdb.ast.query.gen.Datum;
import com.rethinkdb.ast.query.gen.Func;
import com.rethinkdb.ast.query.gen.MakeArray;
import com.rethinkdb.ast.query.gen.MakeObj;
import com.rethinkdb.model.RqlFunction;
import com.rethinkdb.model.RqlLambda;
import com.rethinkdb.proto.Q2L;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class RqlUtil {
    public static RqlQuery toRqlQuery(Object val) {
        return RqlUtil.toRqlQuery(val, 20);
    }

    private static RqlQuery toRqlQuery(Object val, int remainingDepth) {
        if (val instanceof RqlQuery) {
            return (RqlQuery)val;
        }
        if (val instanceof List) {
            ArrayList<Object> innerValues = new ArrayList<Object>();
            for (Object innerValue : (List)val) {
                innerValues.add(RqlUtil.toRqlQuery(innerValue, remainingDepth - 1));
            }
            return new MakeArray(innerValues, null);
        }
        if (val instanceof Map) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)val).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new RethinkDBException("Object key can only be strings");
                }
                obj.put((String)entry.getKey(), RqlUtil.toRqlQuery(entry.getValue()));
            }
            return new MakeObj(obj);
        }
        if (val instanceof RqlLambda) {
            return new Func((RqlLambda)val);
        }
        if (val instanceof Date) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
            df.setTimeZone(tz);
            return RethinkDB.R.ISO8601(df.format((Date)val));
        }
        return new Datum(val);
    }

    public static RqlQuery funcWrap(Object o) {
        final RqlQuery rqlQuery = RqlUtil.toRqlQuery(o);
        if (RqlUtil.hasImplicitVar(rqlQuery)) {
            return new Func(new RqlFunction(){

                @Override
                public RqlQuery apply(RqlQuery row) {
                    return rqlQuery;
                }
            });
        }
        return rqlQuery;
    }

    public static boolean hasImplicitVar(RqlQuery node) {
        if (node.getTermType() == Q2L.Term.TermType.IMPLICIT_VAR) {
            return true;
        }
        for (RqlQuery rqlQuery : node.getArgs()) {
            if (!RqlUtil.hasImplicitVar(rqlQuery)) continue;
            return true;
        }
        for (Map.Entry entry : node.getOptionalArgs().entrySet()) {
            if (!RqlUtil.hasImplicitVar((RqlQuery)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static Q2L.Datum createDatum(Object value) {
        Q2L.Datum.Builder builder = Q2L.Datum.newBuilder();
        if (value == null) {
            return builder.setType(Q2L.Datum.DatumType.R_NULL).build();
        }
        if (value instanceof String) {
            return builder.setType(Q2L.Datum.DatumType.R_STR).setRStr((String)value).build();
        }
        if (value instanceof Number) {
            return builder.setType(Q2L.Datum.DatumType.R_NUM).setRNum(((Number)value).doubleValue()).build();
        }
        if (value instanceof Boolean) {
            return builder.setType(Q2L.Datum.DatumType.R_BOOL).setRBool((Boolean)value).build();
        }
        if (value instanceof Collection) {
            Q2L.Datum.Builder arr = builder.setType(Q2L.Datum.DatumType.R_ARRAY);
            for (Object o : (Collection)value) {
                arr.addRArray(RqlUtil.createDatum(o));
            }
            return arr.build();
        }
        throw new RethinkDBException("Unknown Value can't create datatype for : " + value.getClass());
    }
}

