/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast.query.gen;

import com.google.common.collect.Lists;
import com.rethinkdb.RethinkDBConnection;
import com.rethinkdb.ast.helper.Arguments;
import com.rethinkdb.ast.helper.OptionalArguments;
import com.rethinkdb.ast.query.RqlQuery;
import com.rethinkdb.ast.query.RqlUtil;
import com.rethinkdb.ast.query.gen.Get;
import com.rethinkdb.ast.query.gen.GetAll;
import com.rethinkdb.ast.query.gen.IndexCreate;
import com.rethinkdb.ast.query.gen.IndexDrop;
import com.rethinkdb.ast.query.gen.IndexList;
import com.rethinkdb.ast.query.gen.IndexStatus;
import com.rethinkdb.ast.query.gen.IndexWait;
import com.rethinkdb.ast.query.gen.Insert;
import com.rethinkdb.model.Durability;
import com.rethinkdb.model.RqlFunction;
import com.rethinkdb.proto.Q2L;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table
extends RqlQuery {
    public Table(RqlQuery prev, List<Object> args, Map<String, Object> optionalArgs) {
        super(prev, Q2L.Term.TermType.TABLE, args, optionalArgs);
    }

    public Insert insert(Map<String, Object> dbObject, Durability durability, Boolean returnVals, Boolean upsert) {
        return this.insert(Lists.newArrayList((Object[])new Map[]{dbObject}), durability, returnVals, upsert);
    }

    public Insert insert(Map<String, Object> ... dbObject) {
        return this.insert(Arrays.asList(dbObject), null, null, null);
    }

    public Insert insert(List<Map<String, Object>> dbObjects) {
        return this.insert(dbObjects, null, null, null);
    }

    public Insert insert(List<Map<String, Object>> dbObjects, Durability durability, Boolean returnVals, Boolean upsert) {
        HashMap<String, Object> optionalArgs = new HashMap<String, Object>();
        if (returnVals != null && returnVals.booleanValue()) {
            optionalArgs.put("return_vals", true);
        }
        if (upsert != null) {
            optionalArgs.put("upsert", true);
        }
        if (durability != null) {
            optionalArgs.put("durability", durability.toString());
        }
        return new Insert(this, (List<Object>)new Arguments((Object)Lists.newArrayList(dbObjects)), optionalArgs);
    }

    public Get get(Object key) {
        return new Get(this, (List<Object>)new Arguments(key), null);
    }

    public GetAll getAll(List<Object> keys, String index) {
        return new GetAll(this, (List<Object>)new Arguments(keys), (Map<String, Object>)new OptionalArguments().with("index", index));
    }

    public GetAll getAll(List<Object> keys) {
        return this.getAll(keys, null);
    }

    public IndexCreate indexCreate(String name) {
        return this.indexCreate(name, null, null);
    }

    public IndexCreate indexCreate(String name, RqlFunction function, Boolean multi) {
        Arguments args = new Arguments((Object)name);
        if (function != null) {
            args.add(RqlUtil.funcWrap(function));
        }
        return new IndexCreate(this, (List<Object>)args, (Map<String, Object>)new OptionalArguments().with("multi", multi));
    }

    public IndexDrop indexDrop(String name) {
        return new IndexDrop(this, (List<Object>)new Arguments((Object)name), null);
    }

    public IndexList indexList() {
        return new IndexList(this, null, null);
    }

    public IndexStatus indexStatus(String ... indexNames) {
        return new IndexStatus(this, (List<Object>)new Arguments(indexNames), null);
    }

    public IndexWait indexWait(String ... indexNames) {
        return new IndexWait(this, (List<Object>)new Arguments(indexNames), null);
    }

    @Override
    public List<Map<String, Object>> run(RethinkDBConnection connection) {
        return (List)super.run(connection);
    }
}

