/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.response;

import com.rethinkdb.RethinkDBException;
import com.rethinkdb.proto.Q2L;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class DBResponseMapper {
    public static <T> T fromDatumObject(Q2L.Datum datum) {
        if (datum.getType() == Q2L.Datum.DatumType.R_NULL) {
            return null;
        }
        if (datum.getType() == Q2L.Datum.DatumType.R_NUM || datum.getType() == Q2L.Datum.DatumType.R_STR || datum.getType() == Q2L.Datum.DatumType.R_BOOL) {
            return (T)DBResponseMapper.handleType(datum);
        }
        if (datum.getType() == Q2L.Datum.DatumType.R_OBJECT) {
            HashMap<String, Object> repr = new HashMap<String, Object>();
            for (Q2L.Datum.AssocPair assocPair : datum.getRObjectList()) {
                if (assocPair.getKey().equals("$reql_type$") && "TIME".equals(assocPair.getVal().getRStr())) {
                    return (T)DBResponseMapper.asDate(datum);
                }
                repr.put(assocPair.getKey(), DBResponseMapper.handleType(assocPair.getVal()));
            }
            return (T)repr;
        }
        if (datum.getType() == Q2L.Datum.DatumType.R_ARRAY) {
            return (T)DBResponseMapper.makeArray(datum.getRArrayList());
        }
        throw new RethinkDBException("Can't map datum to JavaObject for {}" + (Object)((Object)datum.getType()));
    }

    private static Date asDate(Q2L.Datum datum) {
        String timezone = "";
        Double epoch_time = 0.0;
        for (Q2L.Datum.AssocPair assocPair : datum.getRObjectList()) {
            if (assocPair.getKey().equals("epoch_time")) {
                epoch_time = assocPair.getVal().getRNum();
            }
            if (!assocPair.getKey().equals("timezone")) continue;
            timezone = assocPair.getVal().getRStr();
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(epoch_time.longValue() * 1000L);
            calendar.setTimeZone(TimeZone.getTimeZone(timezone));
            return calendar.getTime();
        }
        catch (Exception ex) {
            throw new RethinkDBException("Error handling date", ex);
        }
    }

    public static <T> List<T> fromDatumObjectList(List<Q2L.Datum> datums) {
        ArrayList<T> results = new ArrayList<T>();
        for (Q2L.Datum datum : datums) {
            results.add(DBResponseMapper.fromDatumObject(datum));
        }
        return results;
    }

    private static Object handleType(Q2L.Datum val) {
        switch (val.getType()) {
            case R_OBJECT: {
                return DBResponseMapper.fromDatumObject(val);
            }
            case R_STR: {
                return val.getRStr();
            }
            case R_BOOL: {
                return val.getRBool();
            }
            case R_NULL: {
                return null;
            }
            case R_NUM: {
                return val.getRNum();
            }
            case R_ARRAY: {
                return DBResponseMapper.makeArray(val.getRArrayList());
            }
        }
        throw new RuntimeException("Not implemented" + (Object)((Object)val.getType()));
    }

    private static List<Object> makeArray(List<Q2L.Datum> elements) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Q2L.Datum element : elements) {
            objects.add(DBResponseMapper.handleType(element));
        }
        return objects;
    }

    public static <T> T populateObject(T to, Map<String, Object> from) {
        for (Field field : to.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object result = DBResponseMapper.convertField(field, from);
                if (result == null && field.getType().isPrimitive()) continue;
                field.set(to, result);
            }
            catch (IllegalAccessException e) {
                throw new RethinkDBException("Error populating from DBObject: " + field.getName(), e);
            }
        }
        return to;
    }

    public static <T> List<T> populateList(Class<T> clazz, List<Map<String, Object>> from) {
        ArrayList<T> results = new ArrayList<T>();
        for (Map<String, Object> stringObjectMap : from) {
            try {
                results.add(DBResponseMapper.populateObject(clazz.newInstance(), stringObjectMap));
            }
            catch (InstantiationException e) {
                throw new RethinkDBException("Error instantiating " + clazz, e);
            }
            catch (IllegalAccessException e) {
                throw new RethinkDBException("Illegal access on " + clazz, e);
            }
        }
        return results;
    }

    private static Object convertField(Field toField, Map<String, Object> from) {
        if (from.get(toField.getName()) == null) {
            return null;
        }
        if (toField.getType().equals(Integer.class) || toField.getType().equals(Integer.TYPE)) {
            return ((Number)from.get(toField.getName())).intValue();
        }
        if (toField.getType().equals(Float.class) || toField.getType().equals(Float.TYPE)) {
            return Float.valueOf(((Number)from.get(toField.getName())).floatValue());
        }
        return from.get(toField.getName());
    }
}

