/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.logging.QueueingHandler$;
import com.twitter.util.Time$;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.LogRecord;
import scala.Console$;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005eq!B\u0001\u0003\u0011\u0003I\u0011aD)vKV,\u0017N\\4IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00027pO\u001eLgn\u001a\u0006\u0003\u000b\u0019\tq\u0001^<jiR,'OC\u0001\b\u0003\r\u0019w.\\\u0002\u0001!\tQ1\"D\u0001\u0003\r\u0015a!\u0001#\u0001\u000e\u0005=\tV/Z;fS:<\u0007*\u00198eY\u0016\u00148CA\u0006\u000f!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\b\"B\f\f\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015Q2\u0002\"\u0001\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\raB\u000f \t\u0004;\u0001\u0012S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0006$\r\u0011a!\u0001\u0001\u0013\u0014\u0005\r*\u0003C\u0001\u0006'\u0013\t9#AA\u0004IC:$G.\u001a:\t\u0011%\u001a#Q1A\u0005\u0002)\nq\u0001[1oI2,'/F\u0001&\u0011!a3E!A!\u0002\u0013)\u0013\u0001\u00035b]\u0012dWM\u001d\u0011\t\u00119\u001a#\u0011!Q\u0001\n=\nA\"\\1y#V,W/Z*ju\u0016\u0004\"!\b\u0019\n\u0005Er\"aA%oi\")qc\tC\u0001gQ\u0019!\u0005N\u001b\t\u000b%\u0012\u0004\u0019A\u0013\t\u000f9\u0012\u0004\u0013!a\u0001_!9qg\tb\u0001\n#A\u0014a\u00033s_Bdun\u001a(pI\u0016,\u0012!\u000f\t\u0003uur!!H\u001e\n\u0005qr\u0012A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001\u0010\u0010\t\r\u0005\u001b\u0003\u0015!\u0003:\u00031!'o\u001c9M_\u001etu\u000eZ3!\u0011\u001d\u00195E1A\u0005\u0012\u0011\u000b1\u0001\\8h+\u0005)\u0005C\u0001\u0006G\u0013\t9%A\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0013\u000e\u0002\u000b\u0011B#\u0002\t1|w\r\t\u0005\u0007\u0017\u000e\u0002\u000b\u0011\u0002'\u0002\u000bE,X-^3\u0011\u00075\u0013F+D\u0001O\u0015\ty\u0005+\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0015\n\u0002\tU$\u0018\u000e\\\u0005\u0003':\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u0004\"!V,\u000e\u0003YS!a\u0001)\n\u0005a3&!\u0003'pOJ+7m\u001c:e\u0011\u0019Q6\u0005)A\u00057\u00061A\u000f\u001b:fC\u0012\u0004\"a\u0004/\n\u0005u\u0003\"A\u0002+ie\u0016\fG\r\u0003\u0004`G\u0001\u0006I\u0001Y\u0001\u000bG2|7/\u001a'bi\u000eD\u0007CA'b\u0013\t\u0011gJ\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u000b\u0011\u001cC\u0011A3\u0002\u000fA,(\r\\5tQR\u0011a-\u001b\t\u0003;\u001dL!\u0001\u001b\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u000e\u0004\r\u0001V\u0001\u0007e\u0016\u001cwN\u001d3\t\u000b1\u001cC\u0011A7\u0002\u000b\rdwn]3\u0015\u0003\u0019DQa\\\u0012\u0005\u00025\fQA\u001a7vg\"DQ!]\u0012\u0005\u0012I\f!b\u001c8Pm\u0016\u0014h\r\\8x)\t17\u000fC\u0003ka\u0002\u0007A\u000bC\u0003*3\u0001\u0007Q\u000f\u0005\u0002ws:\u0011!b^\u0005\u0003q\n\tq\u0001]1dW\u0006<W-\u0003\u0002{w\nq\u0001*\u00198eY\u0016\u0014h)Y2u_JL(B\u0001=\u0003\u0011\u001dq\u0013\u0004%AA\u0002=BqA`\u0006\u0012\u0002\u0013\u0005q0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003Q3aLA\u0002W\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\b=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0011\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\u0002CA\f\u0017E\u0005I\u0011A@\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\u0002")
public class QueueingHandler
extends Handler {
    private final Handler handler;
    private final String dropLogNode;
    private final Logger log;
    public final LinkedBlockingQueue<LogRecord> com$twitter$logging$QueueingHandler$$queue;
    private final Thread thread;
    public final CountDownLatch com$twitter$logging$QueueingHandler$$closeLatch;

    public static int apply$default$2() {
        return QueueingHandler$.MODULE$.apply$default$2();
    }

    public static int $lessinit$greater$default$2() {
        return QueueingHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static Function0<QueueingHandler> apply(Function0<Handler> function0, int n) {
        return QueueingHandler$.MODULE$.apply(function0, n);
    }

    public Handler handler() {
        return this.handler;
    }

    public String dropLogNode() {
        return this.dropLogNode;
    }

    public Logger log() {
        return this.log;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.com$twitter$logging$QueueingHandler$$queue.offer(record)) {
            this.onOverflow(record);
        }
    }

    @Override
    public void close() {
        this.thread.interrupt();
        this.com$twitter$logging$QueueingHandler$$closeLatch.await();
        this.handler().close();
    }

    @Override
    public void flush() {
        LogRecord record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        while (record != null) {
            this.handler().publish(record);
            record = this.com$twitter$logging$QueueingHandler$$queue.poll();
        }
        this.handler().flush();
    }

    public void onOverflow(LogRecord record) {
        Console$.MODULE$.err().println(String.format("[%s] log queue overflow - record dropped", Time$.MODULE$.now().toString()));
    }

    public QueueingHandler(Handler handler, int maxQueueSize) {
        this.handler = handler;
        super(handler.formatter(), handler.level());
        this.dropLogNode = "";
        this.log = Logger$.MODULE$.apply(this.dropLogNode());
        this.com$twitter$logging$QueueingHandler$$queue = new LinkedBlockingQueue(maxQueueSize);
        this.thread = new $anon$1(this);
        this.com$twitter$logging$QueueingHandler$$closeLatch = new CountDownLatch(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

