/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.Context;
import android.os.Debug;
import android.os.SystemClock;
import android.test.AndroidTestCase;
import android.test.PerformanceTestCase;
import android.test.TestCase;
import android.util.Log;
import com.google.android.collect.Lists;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestRunner
implements PerformanceTestCase.Intermediates {
    public static final int REGRESSION = 0;
    public static final int PERFORMANCE = 1;
    public static final int PROFILING = 2;
    public static final int CLEARSCREEN = 0;
    private static final String TAG = "TestHarness";
    private Context mContext;
    private int mMode = 0;
    private List<Listener> mListeners = Lists.newArrayList();
    private int mPassed;
    private int mFailed;
    private int mInternalIterations;
    private long mStartTime;
    private long mEndTime;
    private String mClassName;
    List<IntermediateTime> mIntermediates = null;
    private static Class mRunnableClass;
    private static Class mJUnitClass;

    public TestRunner(Context context) {
        this.mContext = context;
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void startProfiling() {
        File file = new File("/tmp/trace");
        file.mkdir();
        String base = "/tmp/trace/" + this.mClassName + ".dmtrace";
        Debug.startMethodTracing((String)base, (int)0x800000);
    }

    public void finishProfiling() {
        Debug.stopMethodTracing();
    }

    private void started(String className) {
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mListeners.get(i).started(className);
        }
    }

    private void finished(String className) {
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mListeners.get(i).finished(className);
        }
    }

    private void performance(String className, long itemTimeNS, int iterations, List<IntermediateTime> intermediates) {
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mListeners.get(i).performance(className, itemTimeNS, iterations, intermediates);
        }
    }

    public void passed(String className) {
        ++this.mPassed;
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mListeners.get(i).passed(className);
        }
    }

    public void failed(String className, Throwable exception) {
        ++this.mFailed;
        int count = this.mListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mListeners.get(i).failed(className, exception);
        }
    }

    public int passedCount() {
        return this.mPassed;
    }

    public int failedCount() {
        return this.mFailed;
    }

    public void run(String[] classes) {
        for (String cl : classes) {
            this.run(cl);
        }
    }

    public void setInternalIterations(int count) {
        this.mInternalIterations = count;
    }

    public void startTiming(boolean realTime) {
        this.mStartTime = realTime ? System.currentTimeMillis() : SystemClock.currentThreadTimeMillis();
    }

    public void addIntermediate(String name) {
        this.addIntermediate(name, (System.currentTimeMillis() - this.mStartTime) * 1000000L);
    }

    public void addIntermediate(String name, long timeInNS) {
        this.mIntermediates.add(new IntermediateTime(name, timeInNS));
    }

    public void finishTiming(boolean realTime) {
        this.mEndTime = realTime ? System.currentTimeMillis() : SystemClock.currentThreadTimeMillis();
    }

    public void setPerformanceMode(int mode) {
        this.mMode = mode;
    }

    private void missingTest(String className, Throwable e) {
        this.started(className);
        this.finished(className);
        this.failed(className, e);
    }

    public void run(String className) {
        block33: {
            try {
                this.mClassName = className;
                Class<?> clazz = this.mContext.getClassLoader().loadClass(className);
                Method method = TestRunner.getChildrenMethod(clazz);
                if (method != null) {
                    String[] children = TestRunner.getChildren(method);
                    this.run(children);
                    break block33;
                }
                if (mRunnableClass.isAssignableFrom(clazz)) {
                    Runnable test = (Runnable)clazz.newInstance();
                    TestCase testcase = null;
                    if (test instanceof TestCase) {
                        testcase = (TestCase)test;
                    }
                    Throwable e = null;
                    boolean didSetup = false;
                    this.started(className);
                    try {
                        if (testcase != null) {
                            testcase.setUp(this.mContext);
                            didSetup = true;
                        }
                        if (this.mMode == 1) {
                            this.runInPerformanceMode(test, className, false, className);
                        } else if (this.mMode == 2) {
                            this.startProfiling();
                            test.run();
                            this.finishProfiling();
                        } else {
                            test.run();
                        }
                    }
                    catch (Throwable ex) {
                        e = ex;
                    }
                    if (testcase != null && didSetup) {
                        try {
                            testcase.tearDown();
                        }
                        catch (Throwable ex) {
                            e = ex;
                        }
                    }
                    this.finished(className);
                    if (e == null) {
                        this.passed(className);
                    } else {
                        this.failed(className, e);
                    }
                    break block33;
                }
                if (mJUnitClass.isAssignableFrom(clazz)) {
                    Method[] methods;
                    Throwable e = null;
                    JunitTestSuite suite = new JunitTestSuite();
                    for (Method m : methods = TestRunner.getAllTestMethods(clazz)) {
                        junit.framework.TestCase test = (junit.framework.TestCase)clazz.newInstance();
                        test.setName(m.getName());
                        if (test instanceof AndroidTestCase) {
                            AndroidTestCase testcase = (AndroidTestCase)test;
                            try {
                                testcase.setContext(this.mContext);
                                testcase.setTestContext(this.mContext);
                            }
                            catch (Exception ex) {
                                Log.i((String)TAG, (String)ex.toString());
                            }
                        }
                        suite.addTest((Test)test);
                    }
                    if (this.mMode == 1) {
                        int testCount = suite.testCount();
                        for (int j = 0; j < testCount; ++j) {
                            Test test = suite.testAt(j);
                            this.started(test.toString());
                            try {
                                this.runInPerformanceMode(test, className, true, test.toString());
                            }
                            catch (Throwable ex) {
                                e = ex;
                            }
                            this.finished(test.toString());
                            if (e == null) {
                                this.passed(test.toString());
                                continue;
                            }
                            this.failed(test.toString(), e);
                        }
                        break block33;
                    }
                    if (this.mMode == 2) {
                        this.startProfiling();
                        junit.textui.TestRunner.run((Test)suite);
                        this.finishProfiling();
                    } else {
                        junit.textui.TestRunner.run((Test)suite);
                    }
                    break block33;
                }
                System.out.println("Test wasn't Runnable and didn't have a children method: " + className);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)("ClassNotFoundException for " + className), (String)e.toString());
                if (this.isJunitTest(className)) {
                    this.runSingleJunitTest(className);
                } else {
                    this.missingTest(className, e);
                }
            }
            catch (InstantiationException e) {
                System.out.println("InstantiationException for " + className);
                this.missingTest(className, e);
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException for " + className);
                this.missingTest(className, e);
            }
        }
    }

    public void runInPerformanceMode(Object testCase, String className, boolean junitTest, String testNameInDb) throws Exception {
        boolean increaseIterations = true;
        int iterations = 1;
        long duration = 0L;
        this.mIntermediates = null;
        this.mInternalIterations = 1;
        Class<?> clazz = this.mContext.getClassLoader().loadClass(className);
        Object perftest = clazz.newInstance();
        PerformanceTestCase perftestcase = null;
        if (perftest instanceof PerformanceTestCase) {
            perftestcase = (PerformanceTestCase)perftest;
            if (this.mMode == 0 && perftestcase.isPerformanceOnly()) {
                return;
            }
        }
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        if (perftestcase != null) {
            this.mIntermediates = new ArrayList<IntermediateTime>();
            iterations = perftestcase.startPerformance((PerformanceTestCase.Intermediates)this);
            if (iterations > 0) {
                increaseIterations = false;
            } else {
                iterations = 1;
            }
        }
        Thread.sleep(1000L);
        while (true) {
            long endTime;
            this.mEndTime = 0L;
            this.mStartTime = increaseIterations ? SystemClock.currentThreadTimeMillis() : 0L;
            if (junitTest) {
                for (int i = 0; i < iterations; ++i) {
                    junit.textui.TestRunner.run((Test)((Test)testCase));
                }
            } else {
                Runnable test = (Runnable)testCase;
                for (int i = 0; i < iterations; ++i) {
                    test.run();
                }
            }
            if ((endTime = this.mEndTime) == 0L) {
                endTime = SystemClock.currentThreadTimeMillis();
            }
            duration = endTime - this.mStartTime;
            if (!increaseIterations) break;
            if (duration <= 1L) {
                iterations *= 1000;
                continue;
            }
            if (duration <= 10L) {
                iterations *= 100;
                continue;
            }
            if (duration < 100L) {
                iterations *= 10;
                continue;
            }
            if (duration >= 1000L) break;
            iterations *= (int)(1000L / duration + 2L);
        }
        if (duration != 0L) {
            this.performance(testNameInDb, duration * 1000000L / (long)(iterations *= this.mInternalIterations), iterations, this.mIntermediates);
        }
    }

    public void runSingleJunitTest(String className) {
        block14: {
            Throwable excep = null;
            int index = className.lastIndexOf(36);
            String testName = "";
            String originalClassName = className;
            if (index >= 0) {
                className = className.substring(0, index);
                testName = originalClassName.substring(index + 1);
            }
            try {
                Class<?> clazz = this.mContext.getClassLoader().loadClass(className);
                if (!mJUnitClass.isAssignableFrom(clazz)) break block14;
                junit.framework.TestCase test = (junit.framework.TestCase)clazz.newInstance();
                JunitTestSuite newSuite = new JunitTestSuite();
                test.setName(testName);
                if (test instanceof AndroidTestCase) {
                    AndroidTestCase testcase = (AndroidTestCase)test;
                    try {
                        testcase.setContext(this.mContext);
                    }
                    catch (Exception ex) {
                        Log.w((String)TAG, (String)"Exception encountered while trying to set the context.", (Throwable)ex);
                    }
                }
                newSuite.addTest((Test)test);
                if (this.mMode == 1) {
                    try {
                        this.started(test.toString());
                        this.runInPerformanceMode(test, className, true, test.toString());
                        this.finished(test.toString());
                        if (excep == null) {
                            this.passed(test.toString());
                            break block14;
                        }
                        this.failed(test.toString(), excep);
                    }
                    catch (Throwable ex) {
                        excep = ex;
                    }
                    break block14;
                }
                if (this.mMode == 2) {
                    this.startProfiling();
                    junit.textui.TestRunner.run((Test)newSuite);
                    this.finishProfiling();
                } else {
                    junit.textui.TestRunner.run((Test)newSuite);
                }
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"No test case to run", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Illegal Access Exception", (Throwable)e);
            }
            catch (InstantiationException e) {
                Log.e((String)TAG, (String)"Instantiation Exception", (Throwable)e);
            }
        }
    }

    public static Method getChildrenMethod(Class clazz) {
        try {
            return clazz.getMethod("children", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getChildrenMethod(Context c, String className) {
        try {
            return TestRunner.getChildrenMethod(c.getClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static String[] getChildren(Context c, String className) {
        String[] testChildren;
        Method m = TestRunner.getChildrenMethod(c, className);
        if (m == null & (testChildren = TestRunner.getTestChildren(c, className)) == null) {
            throw new RuntimeException("couldn't get children method for " + className);
        }
        if (m != null) {
            String[] children = TestRunner.getChildren(m);
            if (testChildren != null) {
                String[] allChildren = new String[testChildren.length + children.length];
                System.arraycopy(children, 0, allChildren, 0, children.length);
                System.arraycopy(testChildren, 0, allChildren, children.length, testChildren.length);
                return allChildren;
            }
            return children;
        }
        if (testChildren != null) {
            return testChildren;
        }
        return null;
    }

    public static String[] getChildren(Method m) {
        try {
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("children method is not static");
            }
            return (String[])m.invoke(null, (Object[])null);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new String[0];
    }

    public static String[] getTestChildren(Context c, String className) {
        try {
            Class<?> clazz = c.getClassLoader().loadClass(className);
            if (mJUnitClass.isAssignableFrom(clazz)) {
                return TestRunner.getTestChildren(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"No class found", (Throwable)e);
        }
        return null;
    }

    public static String[] getTestChildren(Class clazz) {
        Method[] methods = TestRunner.getAllTestMethods(clazz);
        String[] onScreenTestNames = new String[methods.length];
        int index = 0;
        for (Method m : methods) {
            onScreenTestNames[index] = clazz.getName() + "$" + m.getName();
            ++index;
        }
        return onScreenTestNames;
    }

    public static Method[] getAllTestMethods(Class clazz) {
        Method[] allMethods = clazz.getDeclaredMethods();
        int numOfMethods = 0;
        for (Method m : allMethods) {
            boolean mTrue = TestRunner.isTestMethod(m);
            if (!mTrue) continue;
            ++numOfMethods;
        }
        int index = 0;
        Method[] testMethods = new Method[numOfMethods];
        for (Method m : allMethods) {
            boolean mTrue = TestRunner.isTestMethod(m);
            if (!mTrue) continue;
            testMethods[index] = m;
            ++index;
        }
        return testMethods;
    }

    private static boolean isTestMethod(Method m) {
        return m.getName().startsWith("test") && m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 0;
    }

    public static int countJunitTests(Class clazz) {
        Method[] allTestMethods = TestRunner.getAllTestMethods(clazz);
        int numberofMethods = allTestMethods.length;
        return numberofMethods;
    }

    public static boolean isTestSuite(Context c, String className) {
        boolean childrenMethods = TestRunner.getChildrenMethod(c, className) != null;
        try {
            int numTests;
            Class<?> clazz = c.getClassLoader().loadClass(className);
            if (mJUnitClass.isAssignableFrom(clazz) && (numTests = TestRunner.countJunitTests(clazz)) > 0) {
                childrenMethods = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return childrenMethods;
    }

    public boolean isJunitTest(String className) {
        int index = className.lastIndexOf(36);
        if (index >= 0) {
            className = className.substring(0, index);
        }
        try {
            Class<?> clazz = this.mContext.getClassLoader().loadClass(className);
            if (mJUnitClass.isAssignableFrom(clazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static int countTests(Context c, String className) {
        try {
            Class<?> clazz = c.getClassLoader().loadClass(className);
            Method method = TestRunner.getChildrenMethod(clazz);
            if (method != null) {
                String[] children = TestRunner.getChildren(method);
                int rv = 0;
                for (String child : children) {
                    rv += TestRunner.countTests(c, child);
                }
                return rv;
            }
            if (mRunnableClass.isAssignableFrom(clazz)) {
                return 1;
            }
            if (mJUnitClass.isAssignableFrom(clazz)) {
                return TestRunner.countJunitTests(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            return 1;
        }
        return 0;
    }

    public static String getTitle(String className) {
        int indexDollar;
        int index;
        int indexDot = className.lastIndexOf(46);
        int n = index = indexDot > (indexDollar = className.lastIndexOf(36)) ? indexDot : indexDollar;
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    static {
        try {
            mRunnableClass = Class.forName("java.lang.Runnable", false, null);
            mJUnitClass = Class.forName("junit.framework.TestCase", false, null);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("shouldn't happen", ex);
        }
    }

    public static interface Listener {
        public void started(String var1);

        public void finished(String var1);

        public void performance(String var1, long var2, int var4, List<IntermediateTime> var5);

        public void passed(String var1);

        public void failed(String var1, Throwable var2);
    }

    public static class IntermediateTime {
        public String name;
        public long timeInNS;

        public IntermediateTime(String name, long timeInNS) {
            this.name = name;
            this.timeInNS = timeInNS;
        }
    }

    public class JunitTestSuite
    extends TestSuite
    implements TestListener {
        boolean mError = false;

        public void run(TestResult result) {
            result.addListener((TestListener)this);
            super.run(result);
            result.removeListener((TestListener)this);
        }

        public void startTest(Test test) {
            TestRunner.this.started(test.toString());
        }

        public void endTest(Test test) {
            TestRunner.this.finished(test.toString());
            if (!this.mError) {
                TestRunner.this.passed(test.toString());
            }
        }

        public void addError(Test test, Throwable t) {
            this.mError = true;
            TestRunner.this.failed(test.toString(), t);
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mError = true;
            TestRunner.this.failed(test.toString(), (Throwable)t);
        }
    }
}

