/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.app.Instrumentation;
import android.os.Bundle;
import android.test.FlakyTest;
import android.test.RepetitiveTest;
import android.test.UiThreadTest;
import java.lang.reflect.InvocationTargetException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class AndroidAnnotatedMethodRule
implements TestRule {
    private Instrumentation fInstrumentation;

    public AndroidAnnotatedMethodRule() {
    }

    public AndroidAnnotatedMethodRule(Instrumentation instrumentation) {
        this.fInstrumentation = instrumentation;
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                int runCount = 1;
                boolean isRepetitive = false;
                if (description.getAnnotation(FlakyTest.class) != null) {
                    runCount = ((FlakyTest)description.getAnnotation(FlakyTest.class)).tolerance();
                } else if (description.getAnnotation(RepetitiveTest.class) != null) {
                    runCount = ((RepetitiveTest)description.getAnnotation(RepetitiveTest.class)).numIterations();
                    isRepetitive = true;
                }
                if (AndroidAnnotatedMethodRule.this.fInstrumentation != null && description.getAnnotation(UiThreadTest.class) != null) {
                    final int tolerance = runCount;
                    final boolean repetitive = isRepetitive;
                    final Throwable[] exceptions = new Throwable[1];
                    AndroidAnnotatedMethodRule.this.fInstrumentation.runOnMainSync(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AndroidAnnotatedMethodRule.this.runMethod(statement, tolerance, repetitive);
                            }
                            catch (Throwable throwable) {
                                exceptions[0] = throwable;
                            }
                        }
                    });
                    if (exceptions[0] != null) {
                        throw exceptions[0];
                    }
                } else {
                    AndroidAnnotatedMethodRule.this.runMethod(statement, runCount, isRepetitive);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMethod(Statement statement, int tolerance, boolean isRepetitive) throws Throwable {
        Throwable exception = null;
        int runCount = 0;
        do {
            try {
                statement.evaluate();
                exception = null;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e.fillInStackTrace();
                    exception = ((InvocationTargetException)e).getTargetException();
                    continue;
                }
                if (e instanceof IllegalAccessException) {
                    e.fillInStackTrace();
                    exception = e;
                    continue;
                }
                exception = e;
            }
            finally {
                ++runCount;
                if (isRepetitive) {
                    Bundle iterations = new Bundle();
                    iterations.putInt("currentiterations", runCount);
                    this.fInstrumentation.sendStatus(2, iterations);
                }
            }
        } while (runCount < tolerance && (isRepetitive || exception != null));
        if (exception != null) {
            throw exception;
        }
    }
}

