/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.content.Context;
import android.os.Build;
import android.test.AndroidTestCase;

abstract class AndroidTestCaseInjector {
    private static final AndroidTestCaseInjector sInjector = AndroidTestCaseInjector.ensureInstance();

    AndroidTestCaseInjector() {
    }

    abstract void setTestContext(AndroidTestCase var1, Context var2);

    abstract Context getTestContext(AndroidTestCase var1);

    private static final AndroidTestCaseInjector ensureInstance() {
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion < 5) {
            return new CupcakeAndroidTestCaseInjector();
        }
        return new EclairAndroidTestCaseInjector();
    }

    static AndroidTestCaseInjector getInstance() {
        return sInjector;
    }

    private static final class EclairAndroidTestCaseInjector
    extends AndroidTestCaseInjector {
        private EclairAndroidTestCaseInjector() {
        }

        @Override
        void setTestContext(AndroidTestCase test, Context context) {
            test.setTestContext(context);
        }

        @Override
        Context getTestContext(AndroidTestCase test) {
            return test.getTestContext();
        }
    }

    private static final class CupcakeAndroidTestCaseInjector
    extends AndroidTestCaseInjector {
        private CupcakeAndroidTestCaseInjector() {
        }

        @Override
        void setTestContext(AndroidTestCase test, Context context) {
        }

        @Override
        Context getTestContext(AndroidTestCase test) {
            return null;
        }
    }
}

