/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.test.AndroidTestCase;
import com.uphyca.testing.AndroidTestCaseMethodInvoker;
import com.uphyca.testing.ApplicationTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class ApplicationTestCase<T extends Application> {
    private final ApplicationTester<T> _tester;

    public ApplicationTestCase(Class<T> applicationClass) {
        this._tester = new ApplicationTester<T>(this, applicationClass);
    }

    @Before
    public void setUp() throws Exception {
        this._tester.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this._tester.tearDown();
    }

    @Test
    public void testAndroidTestCaseSetupProperly() {
        this._tester.testAndroidTestCaseSetupProperly();
    }

    @Test
    public final void testApplicationTestCaseSetUpProperly() throws Exception {
        this._tester.testApplicationTestCaseSetUpProperly();
    }

    public void setContext(Context context) {
        this._tester.setContext(context);
    }

    public Context getContext() {
        return this._tester.getContext();
    }

    public void assertActivityRequiresPermission(String packageName, String className, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertActivityRequiresPermission((AndroidTestCase)((Object)this._tester), packageName, className, permission);
    }

    public void assertReadingContentUriRequiresPermission(Uri uri, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertReadingContentUriRequiresPermission((AndroidTestCase)((Object)this._tester), uri, permission);
    }

    public void assertWritingContentUriRequiresPermission(Uri uri, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertWritingContentUriRequiresPermission((AndroidTestCase)((Object)this._tester), uri, permission);
    }

    public T getApplication() {
        return (T)this._tester.getApplication();
    }

    public Context getSystemContext() {
        return this._tester.getSystemContext();
    }

    protected void scrubClass(Class<?> testCaseClass) throws IllegalAccessException {
        this._tester.scrubClass(testCaseClass);
    }
}

