/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class DelegateFactory {
    static final boolean canInvoke(boolean staticMethod, Object receiver) {
        if (staticMethod) {
            return true;
        }
        boolean b = receiver != null;
        return b;
    }

    static final <T> T create(Class<T> type, Class<?> delegateClass, Object delegateInstance) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (delegateClass == null) {
            throw new IllegalArgumentException("delegateClass must not be null");
        }
        InvocationHandlerImpl handler = new InvocationHandlerImpl(type, delegateClass, delegateInstance);
        ClassLoader classLoader = type.getClassLoader();
        Class[] types = new Class[]{type};
        Object proxy = Proxy.newProxyInstance(classLoader, types, (InvocationHandler)handler);
        T t = type.cast(proxy);
        return t;
    }

    public static final <T> T create(Class<T> type, Object delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        T t = DelegateFactory.create(type, delegate.getClass(), delegate);
        return t;
    }

    public static final <T> T create(Class<T> type, String delegateClassName, Object delegate) throws ClassNotFoundException {
        return DelegateFactory.create(type, delegateClassName, type.getClassLoader(), delegate);
    }

    public static final <T> T create(Class<T> type, String delegateClassName, ClassLoader classLoader, Object delegate) throws ClassNotFoundException {
        if (delegateClassName == null) {
            throw new IllegalArgumentException("delegateClassName must not be null");
        }
        Class<?> delegateClass = classLoader.loadClass(delegateClassName);
        T t = DelegateFactory.create(type, delegateClass, delegate);
        return t;
    }

    static final Method getDeclaredMethod(Class<?> type, String name, Class<?>[] params) {
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            boolean b;
            Method[] methods = c.getDeclaredMethods();
            Method m = DelegateFactory.getMostMatchMethod(name, params, methods);
            boolean bl = b = m != null;
            if (!b) continue;
            return m;
        }
        return null;
    }

    static final Method getDelegateMethod(Method method, Class<?> clazz) throws SecurityException {
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        try {
            Method delegateMethod = clazz.getMethod(name, params);
            return delegateMethod;
        }
        catch (NoSuchMethodException e) {
            for (Annotation[] annotations : method.getParameterAnnotations()) {
                if (annotations.length <= 0) continue;
                int jnum = annotations.length;
                for (int j = 0; j < jnum; ++j) {
                    Annotation annon = annotations[j];
                    Class<? extends Annotation> annonType = annon.annotationType();
                    if (!DeclaredIn.class.equals(annonType)) continue;
                    DeclaredIn t = (DeclaredIn)annon;
                    try {
                        Class<?> type = DelegateFactory.class.getClassLoader().loadClass(t.value());
                        params[i] = type;
                        continue;
                    }
                    catch (ClassNotFoundException e2) {
                        params[i] = Object.class;
                    }
                }
            }
            Method delegateMethod = DelegateFactory.getDeclaredMethod(clazz, name, params);
            return delegateMethod;
        }
    }

    static final Field getField(Method method, Class<?> clazz) throws SecurityException {
        String fieldName;
        String name = method.getName();
        if (name.startsWith("set")) {
            fieldName = name.substring(3);
        } else if (name.startsWith("is")) {
            fieldName = name.substring(2);
        } else if (name.startsWith("get")) {
            fieldName = name.substring(3);
        } else {
            throw new IllegalArgumentException();
        }
        Field field = null;
        if (method.getAnnotation(Parameter.class).isStatic()) {
            try {
                field = clazz.getField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        String canonicalName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        for (Class<?> cls = clazz; cls != null; cls = cls.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(canonicalName);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            if (field == null) continue;
            return field;
        }
        return null;
    }

    static final Method getMostMatchMethod(String name, Class<?>[] params, Method[] methods) {
        for (Method m : methods) {
            boolean b = DelegateFactory.isSignatureMatches(m, name, params);
            if (!b) continue;
            return m;
        }
        return null;
    }

    static final boolean hasDelegateMethod(Method m) {
        return m != null;
    }

    static final boolean isParameter(Method m) {
        return m.isAnnotationPresent(Parameter.class);
    }

    static final boolean isMethodStatic(Method m) {
        int modifiers = m.getModifiers();
        boolean b = Modifier.isStatic(modifiers);
        return b;
    }

    static final boolean isSignatureMatches(Method m, String name, Class<?>[] params) {
        String n = m.getName();
        boolean b = n.equals(name);
        if (!b) {
            return false;
        }
        Class<?>[] delegateParams = m.getParameterTypes();
        b = DelegateFactory.isParameterMatches(params, delegateParams);
        return b;
    }

    static final boolean isParameterMatches(Class<?>[] params, Class<?>[] delegateParams) {
        if (params.length != delegateParams.length) {
            return false;
        }
        int num = params.length;
        for (int i = 0; i < num; ++i) {
            if (!(params[i].isPrimitive() ? !params[i].equals(delegateParams[i]) : !delegateParams[i].isAssignableFrom(params[i]))) continue;
            return false;
        }
        return true;
    }

    static final void makeAccessible(Method m) {
        if (m == null) {
            return;
        }
        if (m.isAccessible()) {
            return;
        }
        m.setAccessible(true);
    }

    static final void makeAccessible(Field f) {
        if (f == null) {
            return;
        }
        if (f.isAccessible()) {
            return;
        }
        f.setAccessible(true);
    }

    private static final class InvocationHandlerImpl
    implements InvocationHandler {
        final Object mDelegate;
        final Class<?> mClass;
        final Map<Method, Method> mMethodCache;
        final Map<Method, Field> mFieldCache;
        final Map<Method, Object> mNegativeCache;
        private static final Object UNRESOLVED = new Object();

        InvocationHandlerImpl(Class<?> receiver, Class<?> delegateClass, Object delegateInstance) {
            this.mDelegate = delegateInstance;
            this.mClass = delegateClass;
            this.mMethodCache = new ConcurrentHashMap<Method, Method>();
            this.mFieldCache = new ConcurrentHashMap<Method, Field>();
            this.mNegativeCache = new ConcurrentHashMap<Method, Object>();
        }

        @Override
        public final Object invoke(Object target, Method method, Object[] args) throws Throwable {
            boolean invoke;
            if (DelegateFactory.isParameter(method)) {
                return this.obtainField(method, args);
            }
            Method delegateMethod = this.getMethodFromCache(method);
            if (!DelegateFactory.hasDelegateMethod(delegateMethod)) {
                return this.unresolved(method.getReturnType());
            }
            Object receiver = null;
            boolean staticMethod = DelegateFactory.isMethodStatic(delegateMethod);
            if (!staticMethod) {
                receiver = this.mDelegate;
            }
            if (!(invoke = DelegateFactory.canInvoke(staticMethod, receiver))) {
                return null;
            }
            Object res = delegateMethod.invoke(receiver, args);
            if (method.getReturnType().isAnnotationPresent(Delegate.class)) {
                return DelegateFactory.create(method.getReturnType(), res);
            }
            return res;
        }

        private Object obtainField(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException {
            Field field = this.getFieldFromCache(method);
            if (field == null) {
                return null;
            }
            if (args == null || args.length == 0) {
                Object f = field.get(this.mDelegate);
                if (method.getReturnType().isAnnotationPresent(Delegate.class)) {
                    return DelegateFactory.create(method.getReturnType(), f);
                }
                return f;
            }
            field.set(this.mDelegate, args[0]);
            return null;
        }

        private Object unresolved(Class<?> returnType) {
            if (!returnType.isPrimitive()) {
                return null;
            }
            if (returnType.equals(Boolean.TYPE)) {
                return false;
            }
            if (returnType.equals(Byte.TYPE)) {
                return (byte)0;
            }
            if (returnType.equals(Short.TYPE)) {
                return (short)0;
            }
            if (returnType.equals(Integer.TYPE)) {
                return 0;
            }
            if (returnType.equals(Long.TYPE)) {
                return 0L;
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (returnType.equals(Double.TYPE)) {
                return 0.0;
            }
            return null;
        }

        private Method getMethodFromCache(Method method) throws SecurityException {
            Method delegate = this.mMethodCache.get(method);
            if (delegate != null) {
                return delegate;
            }
            if (this.mNegativeCache.containsKey(method)) {
                return null;
            }
            delegate = DelegateFactory.getDelegateMethod(method, this.mClass);
            if (delegate == null) {
                this.mNegativeCache.put(method, UNRESOLVED);
                return null;
            }
            DelegateFactory.makeAccessible(delegate);
            this.mMethodCache.put(method, delegate);
            return delegate;
        }

        private Field getFieldFromCache(Method method) throws SecurityException {
            Field field = this.mFieldCache.get(method);
            if (field != null) {
                return field;
            }
            if (this.mNegativeCache.containsKey(method)) {
                return null;
            }
            field = DelegateFactory.getField(method, this.mClass);
            if (field == null) {
                this.mNegativeCache.put(method, UNRESOLVED);
                return null;
            }
            DelegateFactory.makeAccessible(field);
            this.mFieldCache.put(method, field);
            return field;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Delegate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameter {
        public boolean isStatic() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface DeclaredIn {
        public String value();
    }
}

