/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.app.Instrumentation;
import android.content.Context;
import android.os.PerformanceCollector;
import android.test.AndroidTestCase;
import android.test.InstrumentationTestCase;
import android.test.PerformanceCollectorTestCase;
import com.uphyca.testing.AndroidTestCaseInjector;
import com.uphyca.testing.InstrumentationTestCaseInjector;
import junit.framework.Test;

public abstract class Infrastructure {
    private static final ThreadLocal<Context> sContext = new ThreadLocal();
    private static final ThreadLocal<Context> sTestContext = new ThreadLocal();
    private static final ThreadLocal<Instrumentation> sInstrumentation = new ThreadLocal();
    private static final ThreadLocal<PerformanceCollector.PerformanceResultsWriter> sPerformanceResultsWriter = new ThreadLocal();

    public static void setContext(Context context) {
        sContext.set(context);
    }

    public static void setTestContext(Context context) {
        sTestContext.set(context);
    }

    public static void setInstrumentation(Instrumentation instrumentation) {
        sInstrumentation.set(instrumentation);
    }

    public static void setPerformanceResultsWriter(PerformanceCollector.PerformanceResultsWriter performanceResultsWriter) {
        sPerformanceResultsWriter.set(performanceResultsWriter);
    }

    public static Context getContext() {
        return sContext.get();
    }

    public static Context getTestContext() {
        return sTestContext.get();
    }

    public static Instrumentation getInstrumentation() {
        return sInstrumentation.get();
    }

    public static PerformanceCollector.PerformanceResultsWriter getPerformanceResultsWriter() {
        return sPerformanceResultsWriter.get();
    }

    public static void setContextToAndroidTestCase(AndroidTestCase test) {
        test.setContext(sContext.get());
        AndroidTestCaseInjector injector = AndroidTestCaseInjector.getInstance();
        injector.setTestContext(test, sTestContext.get());
    }

    public static void setInstrumentationToInstrumentationTest(InstrumentationTestCase test) {
        InstrumentationTestCaseInjector injector = InstrumentationTestCaseInjector.getInstance();
        injector.injectInstrumentation(test, sInstrumentation.get());
    }

    public static void setPerformanceWriterIfPerformanceCollectorTestCase(Object test) {
        if (PerformanceCollectorTestCase.class.isAssignableFrom(test.getClass())) {
            ((PerformanceCollectorTestCase)test).setPerformanceResultsWriter(sPerformanceResultsWriter.get());
        }
    }

    public static void setContextIfAndroidTestCase(Test test, Context context, Context testContext) {
        if (AndroidTestCase.class.isAssignableFrom(test.getClass())) {
            ((AndroidTestCase)test).setContext(context);
            AndroidTestCaseInjector injector = AndroidTestCaseInjector.getInstance();
            injector.setTestContext((AndroidTestCase)test, sTestContext.get());
        }
    }

    public static void setInstrumentationIfInstrumentationTestCase(Test test, Instrumentation instrumentation) {
        if (InstrumentationTestCase.class.isAssignableFrom(test.getClass())) {
            InstrumentationTestCaseInjector injector = InstrumentationTestCaseInjector.getInstance();
            injector.injectInstrumentation((InstrumentationTestCase)test, sInstrumentation.get());
        }
    }

    public static void setPerformanceWriterIfPerformanceCollectorTestCase(Test test, PerformanceCollector.PerformanceResultsWriter writer) {
        if (PerformanceCollectorTestCase.class.isAssignableFrom(test.getClass())) {
            ((PerformanceCollectorTestCase)test).setPerformanceResultsWriter(writer);
        }
    }

    public static void clear() {
        sContext.remove();
        sTestContext.remove();
        sInstrumentation.remove();
        sPerformanceResultsWriter.remove();
    }
}

