/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.annotation.TargetApi;
import android.app.Instrumentation;
import android.os.Build;
import android.test.InstrumentationTestCase;

abstract class InstrumentationTestCaseInjector {
    private static final InstrumentationTestCaseInjector sInjector = InstrumentationTestCaseInjector.ensureInstance();

    InstrumentationTestCaseInjector() {
    }

    abstract void injectInstrumentation(InstrumentationTestCase var1, Instrumentation var2);

    private static final InstrumentationTestCaseInjector ensureInstance() {
        int sdkVersion = Integer.parseInt(Build.VERSION.SDK);
        if (sdkVersion < 5) {
            return new CupcakeInstrumentationInjector();
        }
        return new EclairInstrumentationInjector();
    }

    static InstrumentationTestCaseInjector getInstance() {
        return sInjector;
    }

    private static final class EclairInstrumentationInjector
    extends InstrumentationTestCaseInjector {
        private EclairInstrumentationInjector() {
        }

        @Override
        @TargetApi(value=5)
        public void injectInstrumentation(InstrumentationTestCase test, Instrumentation instrumentation) {
            test.injectInstrumentation(instrumentation);
        }
    }

    private static final class CupcakeInstrumentationInjector
    extends InstrumentationTestCaseInjector {
        private CupcakeInstrumentationInjector() {
        }

        @Override
        public void injectInstrumentation(InstrumentationTestCase test, Instrumentation instrumentation) {
            test.injectInsrumentation(instrumentation);
        }
    }
}

