/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.test.IsolatedContext;
import android.test.RenamingDelegatingContext;
import android.test.mock.MockContentResolver;
import android.test.mock.MockContext;
import com.uphyca.testing.AndroidTestCase;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Before;

public class IsolatedAndroidTestCase
extends AndroidTestCase {
    private IsolatedContext _isolatedContext;
    private Set<SQLiteDatabase> _openedDataabses;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this._openedDataabses = new HashSet<SQLiteDatabase>();
        String filenamePrefix = "test.";
        RenamingDelegatingContext2 targetContextWrapper = new RenamingDelegatingContext2((Context)new MockContext2(), this.getContext(), "test.");
        this._isolatedContext = new IsolatedContext((ContentResolver)new MockContentResolver(), (Context)targetContextWrapper);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        for (SQLiteDatabase each : this._openedDataabses) {
            if (!each.isOpen()) continue;
            each.close();
        }
    }

    protected IsolatedContext getMockContext() {
        return this._isolatedContext;
    }

    private class RenamingDelegatingContext2
    extends RenamingDelegatingContext {
        public RenamingDelegatingContext2(Context context, Context fileContext, String filePrefix) {
            super(context, fileContext, filePrefix);
        }

        public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
            SQLiteDatabase sqlite = super.openOrCreateDatabase(name, mode, factory);
            IsolatedAndroidTestCase.this._openedDataabses.add(sqlite);
            return sqlite;
        }

        @SuppressLint(value={"NewApi"})
        public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
            SQLiteDatabase sqlite = super.openOrCreateDatabase(name, mode, factory, errorHandler);
            IsolatedAndroidTestCase.this._openedDataabses.add(sqlite);
            return sqlite;
        }
    }

    private class MockContext2
    extends MockContext {
        private MockContext2() {
        }

        public Resources getResources() {
            return IsolatedAndroidTestCase.this.getContext().getResources();
        }

        public File getDir(String name, int mode) {
            String dirName = String.format("mockcontext2_%s", name);
            return IsolatedAndroidTestCase.this.getContext().getDir(dirName, mode);
        }

        public Context getApplicationContext() {
            return IsolatedAndroidTestCase.this.getMockContext();
        }
    }
}

