/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.annotation.TargetApi;
import android.app.Instrumentation;
import android.os.Bundle;
import android.os.Debug;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PerformanceCollector;
import android.test.AndroidTestRunner;
import android.test.InstrumentationTestCase;
import android.test.InstrumentationTestRunner;
import android.test.RepetitiveTest;
import android.test.TestPrinter;
import android.test.TestSuiteProvider;
import android.test.TimedTest;
import android.util.Log;
import com.android.internal.util.Predicate;
import com.android.internal.util.Predicates;
import com.uphyca.testing.DelegateFactory;
import com.uphyca.testing.Infrastructure;
import com.uphyca.testing.JUnit4TestClassAdaptingListener;
import com.uphyca.testing.android.ClassPathPackageInfoSource;
import com.uphyca.testing.android.JUnit4NoExecTestResult;
import com.uphyca.testing.android.suitebuilder.JUnit4TestPredicates;
import com.uphyca.testing.android.suitebuilder.JUnit4TestSuiteBuilder;
import com.uphyca.testing.android.suitebuilder.annotation.JUnit4HasAnnotation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;

public class JUnit4InstrumentationTestRunner
extends InstrumentationTestRunner
implements TestSuiteProvider {
    public static final String ARGUMENT_TEST_CLASS = "class";
    public static final String ARGUMENT_TEST_PACKAGE = "package";
    public static final String ARGUMENT_TEST_SIZE_PREDICATE = "size";
    public static final String ARGUMENT_DELAY_MSEC = "delay_msec";
    private static final String SMALL_SUITE = "small";
    private static final String MEDIUM_SUITE = "medium";
    private static final String LARGE_SUITE = "large";
    private static final String ARGUMENT_LOG_ONLY = "log";
    static final String ARGUMENT_ANNOTATION = "annotation";
    static final String ARGUMENT_NOT_ANNOTATION = "notAnnotation";
    private static final float SMALL_SUITE_MAX_RUNTIME = 100.0f;
    private static final float MEDIUM_SUITE_MAX_RUNTIME = 1000.0f;
    public static final String REPORT_VALUE_ID = "InstrumentationTestRunner";
    public static final String REPORT_KEY_NUM_TOTAL = "numtests";
    public static final String REPORT_KEY_NUM_CURRENT = "current";
    public static final String REPORT_KEY_NAME_CLASS = "class";
    public static final String REPORT_KEY_NAME_TEST = "test";
    private static final String REPORT_KEY_RUN_TIME = "runtime";
    private static final String REPORT_KEY_NUM_ITERATIONS = "numiterations";
    private static final String REPORT_KEY_SUITE_ASSIGNMENT = "suiteassignment";
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";
    public static final int REPORT_VALUE_RESULT_START = 1;
    public static final int REPORT_VALUE_RESULT_OK = 0;
    public static final int REPORT_VALUE_RESULT_ERROR = -1;
    public static final int REPORT_VALUE_RESULT_FAILURE = -2;
    public static final String REPORT_KEY_STACK = "stack";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private static final String LOG_TAG = "InstrumentationTestRunner";
    private final Bundle mResults = new Bundle();
    private Bundle mArguments;
    private boolean mDebug;
    private boolean mJustCount;
    private boolean mSuiteAssignmentMode;
    private int mTestCount;
    private String mPackageOfTests;
    private boolean mCoverage;
    private String mCoverageFilePath;
    private int mDelayMsec;
    private JUnitCore junit4;
    private Request junit4Request;
    private Runner junit4Runner;
    private TestResult junit4results;
    private WatcherResultPrinter performanceResultPrinter;

    @TargetApi(value=8)
    private String getTargetContextPackageCodePath() {
        return this.getTargetContext().getPackageCodePath();
    }

    @TargetApi(value=8)
    private String getContextPackageCodePath() {
        return this.getContext().getPackageCodePath();
    }

    public void onCreate(Bundle arguments) {
        this.mArguments = arguments;
        String[] apkPaths = new String[]{this.getTargetContextPackageCodePath(), this.getContextPackageCodePath()};
        ClassPathPackageInfoSource.setApkPaths(apkPaths);
        Predicate<Description> testSizePredicate = null;
        Predicate<Description> testAnnotationPredicate = null;
        Predicate<Description> testNotAnnotationPredicate = null;
        String testClassesArg = null;
        boolean logOnly = false;
        if (arguments != null) {
            testClassesArg = arguments.getString("class");
            this.mDebug = this.getBooleanArgument(arguments, "debug");
            this.mJustCount = this.getBooleanArgument(arguments, "count");
            this.mSuiteAssignmentMode = this.getBooleanArgument(arguments, "suiteAssignment");
            this.mPackageOfTests = arguments.getString(ARGUMENT_TEST_PACKAGE);
            testSizePredicate = this.getSizePredicateFromArg(arguments.getString(ARGUMENT_TEST_SIZE_PREDICATE));
            testAnnotationPredicate = this.getAnnotationPredicate(arguments.getString(ARGUMENT_ANNOTATION));
            testNotAnnotationPredicate = this.getNotAnnotationPredicate(arguments.getString(ARGUMENT_NOT_ANNOTATION));
            logOnly = this.getBooleanArgument(arguments, ARGUMENT_LOG_ONLY);
            this.mCoverage = this.getBooleanArgument(arguments, "coverage");
            this.mCoverageFilePath = arguments.getString("coverageFile");
            try {
                Object delay = arguments.get(ARGUMENT_DELAY_MSEC);
                if (delay != null) {
                    this.mDelayMsec = Integer.parseInt(delay.toString());
                }
            }
            catch (NumberFormatException e) {
                Log.e((String)"InstrumentationTestRunner", (String)"Invalid delay_msec parameter", (Throwable)e);
            }
        }
        JUnit4TestSuiteBuilder testSuiteBuilder = new JUnit4TestSuiteBuilder(((Object)((Object)this)).getClass().getName(), this.getTargetContext().getClassLoader());
        if (testSizePredicate != null) {
            testSuiteBuilder.addRequirements(testSizePredicate);
        }
        if (testAnnotationPredicate != null) {
            testSuiteBuilder.addRequirements(testAnnotationPredicate);
        }
        if (testNotAnnotationPredicate != null) {
            testSuiteBuilder.addRequirements(testNotAnnotationPredicate);
        }
        if (testClassesArg == null) {
            if (this.mPackageOfTests != null) {
                testSuiteBuilder.includePackages(this.mPackageOfTests);
            } else {
                Class<?>[] testSuite = this.getTestSuiteClasses();
                if (testSuite != null) {
                    testSuiteBuilder.addTestSuite(testSuite);
                } else {
                    testSuiteBuilder.includePackages("");
                }
            }
        } else {
            this.parseTestClasses(testClassesArg, testSuiteBuilder);
        }
        testSuiteBuilder.addRequirements(this.getBuilderRequirements());
        this.junit4results = logOnly ? new JUnit4NoExecTestResult() : new TestResult();
        this.junit4 = new JUnitCore();
        this.junit4.addListener((RunListener)new JUnit4TestClassAdaptingListener(this.junit4results, JUnit4TestAdapterCache.getDefault()));
        if (!this.mSuiteAssignmentMode) {
            this.performanceResultPrinter = new WatcherResultPrinter(0);
        }
        this.junit4Request = testSuiteBuilder.build();
        this.junit4Runner = this.junit4Request.getRunner();
        this.mTestCount = this.junit4Runner.testCount();
        if (this.performanceResultPrinter != null) {
            this.performanceResultPrinter.setNumTests(this.mTestCount);
        }
        if (this.mSuiteAssignmentMode) {
            this.junit4results.addListener((TestListener)new SuiteAssignmentPrinter());
        } else {
            this.junit4results.addListener((TestListener)new TestPrinter("TestRunner", false));
            this.junit4results.addListener((TestListener)this.performanceResultPrinter);
        }
        this.start();
    }

    public Bundle getBundle() {
        return this.mArguments;
    }

    List<Predicate<Description>> getBuilderRequirements() {
        return new ArrayList<Predicate<Description>>();
    }

    private void parseTestClasses(String testClassArg, JUnit4TestSuiteBuilder testSuiteBuilder) {
        String[] testClasses;
        for (String testClass : testClasses = testClassArg.split(",")) {
            this.parseTestClass(testClass, testSuiteBuilder);
        }
    }

    private void parseTestClass(String testClassName, JUnit4TestSuiteBuilder testSuiteBuilder) {
        int methodSeparatorIndex = testClassName.indexOf(35);
        String testMethodName = null;
        if (methodSeparatorIndex > 0) {
            testMethodName = testClassName.substring(methodSeparatorIndex + 1);
            testClassName = testClassName.substring(0, methodSeparatorIndex);
        }
        testSuiteBuilder.addTestClassByName(testClassName, testMethodName, this.getTargetContext());
    }

    protected AndroidTestRunner getAndroidTestRunner() {
        throw new UnsupportedOperationException();
    }

    private boolean getBooleanArgument(Bundle arguments, String tag) {
        String tagString = arguments.getString(tag);
        return tagString != null && Boolean.parseBoolean(tagString);
    }

    private Predicate<Description> getSizePredicateFromArg(String sizeArg) {
        if (SMALL_SUITE.equals(sizeArg)) {
            return JUnit4TestPredicates.SELECT_SMALL;
        }
        if (MEDIUM_SUITE.equals(sizeArg)) {
            return JUnit4TestPredicates.SELECT_MEDIUM;
        }
        if (LARGE_SUITE.equals(sizeArg)) {
            return JUnit4TestPredicates.SELECT_LARGE;
        }
        return null;
    }

    private Predicate<Description> getAnnotationPredicate(String annotationClassName) {
        Class<? extends Annotation> annotationClass = this.getAnnotationClass(annotationClassName);
        if (annotationClass != null) {
            return new JUnit4HasAnnotation(annotationClass);
        }
        return null;
    }

    private Predicate<Description> getNotAnnotationPredicate(String annotationClassName) {
        Class<? extends Annotation> annotationClass = this.getAnnotationClass(annotationClassName);
        if (annotationClass != null) {
            return Predicates.not(new JUnit4HasAnnotation(annotationClass));
        }
        return null;
    }

    private Class<? extends Annotation> getAnnotationClass(String annotationClassName) {
        if (annotationClassName == null) {
            return null;
        }
        try {
            Class<?> annotationClass = Class.forName(annotationClassName);
            if (annotationClass.isAnnotation()) {
                return annotationClass;
            }
            Log.e((String)"InstrumentationTestRunner", (String)String.format("Provided annotation value %s is not an Annotation", annotationClassName));
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"InstrumentationTestRunner", (String)String.format("Could not find class for specified annotation %s", annotationClassName));
        }
        return null;
    }

    void prepareLooper() {
        Looper.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStart() {
        this.prepareLooper();
        if (this.mJustCount) {
            this.mResults.putString("id", "InstrumentationTestRunner");
            this.mResults.putInt(REPORT_KEY_NUM_TOTAL, this.mTestCount);
            this.finish(-1, this.mResults);
            return;
        }
        if (this.mDebug) {
            Debug.waitForDebugger();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(byteArrayOutputStream);
        try {
            StringResultPrinterWrapper resultPrinter = this.createStringResultPrinter(writer);
            this.junit4results.addListener((TestListener)resultPrinter);
            Infrastructure.setContext(this.getTargetContext());
            Infrastructure.setTestContext(this.getContext());
            Infrastructure.setInstrumentation((Instrumentation)this);
            Infrastructure.setPerformanceResultsWriter(this.performanceResultPrinter);
            long startTime = System.currentTimeMillis();
            try {
                this.junit4.run(this.junit4Request);
            }
            finally {
                Infrastructure.clear();
            }
            long runTime = System.currentTimeMillis() - startTime;
            resultPrinter.print(this.junit4results, runTime);
        }
        catch (Throwable t) {
            try {
                writer.println(String.format("Test run aborted due to unexpected exception: %s", t.getMessage()));
                t.printStackTrace(writer);
            }
            catch (Throwable throwable) {
                this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.junit4Runner.getDescription().getDisplayName(), byteArrayOutputStream.toString()));
                if (this.mCoverage) {
                    this.generateCoverageReport();
                }
                writer.close();
                this.finish(-1, this.mResults);
                throw throwable;
            }
            this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.junit4Runner.getDescription().getDisplayName(), byteArrayOutputStream.toString()));
            if (this.mCoverage) {
                this.generateCoverageReport();
            }
            writer.close();
            this.finish(-1, this.mResults);
            return;
        }
        this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.junit4Runner.getDescription().getDisplayName(), byteArrayOutputStream.toString()));
        if (this.mCoverage) {
            this.generateCoverageReport();
        }
        writer.close();
        this.finish(-1, this.mResults);
        return;
    }

    private StringResultPrinterWrapper createStringResultPrinter(PrintStream ps) {
        Class<?>[] declaredClasses;
        for (Class<?> c : declaredClasses = InstrumentationTestRunner.class.getDeclaredClasses()) {
            if (!c.getName().endsWith("StringResultPrinter")) continue;
            InnerTypeBuilder<StringResultPrinterWrapper> builder = new InnerTypeBuilder<StringResultPrinterWrapper>(this, StringResultPrinterWrapper.class);
            StringResultPrinterWrapper stringResultPriter = builder.setUnderlyingType(c).setArgTypes(PrintStream.class).build(ps);
            return stringResultPriter;
        }
        throw new IllegalStateException();
    }

    public TestSuite getTestSuite() {
        return this.getAllTests();
    }

    public TestSuite getAllTests() {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getTestSuiteClasses() {
        return this.getAllTestClasses();
    }

    public Class<?>[] getAllTestClasses() {
        return null;
    }

    public ClassLoader getLoader() {
        return null;
    }

    private void generateCoverageReport() {
        String coverageFilePath = this.getCoverageFilePath();
        File coverageFile = new File(coverageFilePath);
        try {
            Class<?> emmaRTClass = Class.forName("com.vladium.emma.rt.RT");
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            this.mResults.putString(REPORT_KEY_COVERAGE_PATH, coverageFilePath);
            String currentStream = this.mResults.getString("stream");
            this.mResults.putString("stream", String.format("%s\nGenerated code coverage data to %s", currentStream, coverageFilePath));
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError("Is emma jar on classpath?", e);
        }
        catch (SecurityException e) {
            this.reportEmmaError(e);
        }
        catch (NoSuchMethodException e) {
            this.reportEmmaError(e);
        }
        catch (IllegalArgumentException e) {
            this.reportEmmaError(e);
        }
        catch (IllegalAccessException e) {
            this.reportEmmaError(e);
        }
        catch (InvocationTargetException e) {
            this.reportEmmaError(e);
        }
    }

    private String getCoverageFilePath() {
        if (this.mCoverageFilePath == null) {
            return this.getTargetContext().getFilesDir().getAbsolutePath() + File.separator + DEFAULT_COVERAGE_FILE_NAME;
        }
        return this.mCoverageFilePath;
    }

    private void reportEmmaError(Exception e) {
        this.reportEmmaError("", e);
    }

    private void reportEmmaError(String hint, Exception e) {
        String msg = "Failed to generate emma coverage. " + hint;
        Log.e((String)"InstrumentationTestRunner", (String)msg, (Throwable)e);
        this.mResults.putString("stream", "\nError: " + msg);
    }

    private static interface StringResultPrinterWrapper
    extends TestListener {
        public void print(TestResult var1, long var2);
    }

    private static final class InnerTypeBuilder<T> {
        private static final Class<InstrumentationTestRunner> ENCLOSING_TYPE = InstrumentationTestRunner.class;
        private InstrumentationTestRunner _enclosingInstance;
        private Class<?> _underlyingType;
        private Class<T> _wrapperType;
        private Class<?>[] _argTypes;

        public InnerTypeBuilder(InstrumentationTestRunner enclosingInstance, Class<T> wrapperType) {
            this._enclosingInstance = enclosingInstance;
            this._wrapperType = wrapperType;
        }

        public InnerTypeBuilder<T> setUnderlyingType(Class<?> underlyingType) {
            this._underlyingType = underlyingType;
            return this;
        }

        public InnerTypeBuilder<T> setArgTypes(Class<?> ... argTypes) {
            this._argTypes = argTypes;
            return this;
        }

        public T build(Object ... args) {
            Constructor<?> constructor = InnerTypeBuilder.getMatchedConstructor(this._underlyingType, this._argTypes);
            Object underlying = this.instantiate(constructor, args);
            T wrapper = DelegateFactory.create(this._wrapperType, underlying);
            return wrapper;
        }

        private Object instantiate(Constructor<?> constructor, Object[] args) {
            Object[] exactArgs = new Object[args.length + 1];
            exactArgs[0] = this._enclosingInstance;
            System.arraycopy(args, 0, exactArgs, 1, args.length);
            try {
                Object resultPrinter = constructor.newInstance(exactArgs);
                return resultPrinter;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }

        private static Constructor<?> getMatchedConstructor(Class<?> clazz, Class<?>[] argTypes) {
            Class[] exactArgTypes = new Class[argTypes.length + 1];
            exactArgTypes[0] = ENCLOSING_TYPE;
            System.arraycopy(argTypes, 0, exactArgTypes, 1, argTypes.length);
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(exactArgTypes);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
    }

    private class WatcherResultPrinter
    implements TestListener,
    PerformanceCollector.PerformanceResultsWriter {
        private final Bundle mResultTemplate;
        Bundle mTestResult;
        int mTestNum = 0;
        int mTestResultCode = 0;
        String mTestClass = null;
        PerformanceCollector mPerfCollector = new PerformanceCollector();
        boolean mIsTimedTest = false;
        boolean mIncludeDetailedStats = false;

        public WatcherResultPrinter(int numTests) {
            this.mResultTemplate = new Bundle();
            this.mResultTemplate.putString("id", "InstrumentationTestRunner");
            this.mResultTemplate.putInt(JUnit4InstrumentationTestRunner.REPORT_KEY_NUM_TOTAL, numTests);
        }

        public void setNumTests(int numTests) {
            this.mResultTemplate.putInt(JUnit4InstrumentationTestRunner.REPORT_KEY_NUM_TOTAL, numTests);
        }

        public void startTest(Test test) {
            String testClass = ((Describable)test).getDescription().getClassName();
            String testName = ((Describable)test).getDescription().getMethodName();
            this.mTestResult = new Bundle(this.mResultTemplate);
            this.mTestResult.putString("class", testClass);
            this.mTestResult.putString(JUnit4InstrumentationTestRunner.REPORT_KEY_NAME_TEST, testName);
            this.mTestResult.putInt(JUnit4InstrumentationTestRunner.REPORT_KEY_NUM_CURRENT, ++this.mTestNum);
            if (testClass != null && !testClass.equals(this.mTestClass)) {
                this.mTestResult.putString("stream", String.format("\n%s:", testClass));
                this.mTestClass = testClass;
            } else {
                this.mTestResult.putString("stream", "");
            }
            Method testMethod = null;
            try {
                testMethod = test.getClass().getMethod(testName, new Class[0]);
                if (testMethod.isAnnotationPresent(RepetitiveTest.class)) {
                    int numIterations = testMethod.getAnnotation(RepetitiveTest.class).numIterations();
                    this.mTestResult.putInt(JUnit4InstrumentationTestRunner.REPORT_KEY_NUM_ITERATIONS, numIterations);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if (this.mTestNum == 1) {
                    Thread.sleep(JUnit4InstrumentationTestRunner.this.mDelayMsec);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            JUnit4InstrumentationTestRunner.this.sendStatus(1, this.mTestResult);
            this.mTestResultCode = 0;
            this.mIsTimedTest = false;
            this.mIncludeDetailedStats = false;
            try {
                if (testMethod != null && testMethod.isAnnotationPresent(TimedTest.class)) {
                    this.mIsTimedTest = true;
                    this.mIncludeDetailedStats = testMethod.getAnnotation(TimedTest.class).includeDetailedStats();
                } else if (test.getClass().isAnnotationPresent(TimedTest.class)) {
                    this.mIsTimedTest = true;
                    this.mIncludeDetailedStats = test.getClass().getAnnotation(TimedTest.class).includeDetailedStats();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (this.mIsTimedTest && this.mIncludeDetailedStats) {
                this.mPerfCollector.beginSnapshot("");
            } else if (this.mIsTimedTest) {
                this.mPerfCollector.startTiming("");
            }
        }

        public void addError(Test test, Throwable t) {
            this.mTestResult.putString(JUnit4InstrumentationTestRunner.REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace((Throwable)t));
            this.mTestResultCode = -1;
            this.mTestResult.putString("stream", String.format("\nError in %s:\n%s", ((Describable)test).getDescription().getMethodName(), BaseTestRunner.getFilteredTrace((Throwable)t)));
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mTestResult.putString(JUnit4InstrumentationTestRunner.REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace((Throwable)t));
            this.mTestResultCode = -2;
            this.mTestResult.putString("stream", String.format("\nFailure in %s:\n%s", ((Describable)test).getDescription().getMethodName(), BaseTestRunner.getFilteredTrace((Throwable)t)));
        }

        public void endTest(Test test) {
            if (this.mIsTimedTest && this.mIncludeDetailedStats) {
                this.mTestResult.putAll(this.mPerfCollector.endSnapshot());
            } else if (this.mIsTimedTest) {
                this.writeStopTiming(this.mPerfCollector.stopTiming(""));
            }
            if (this.mTestResultCode == 0) {
                this.mTestResult.putString("stream", ".");
            }
            JUnit4InstrumentationTestRunner.this.sendStatus(this.mTestResultCode, this.mTestResult);
            try {
                Thread.sleep(JUnit4InstrumentationTestRunner.this.mDelayMsec);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void writeBeginSnapshot(String label) {
        }

        @Override
        public void writeEndSnapshot(Bundle results) {
            JUnit4InstrumentationTestRunner.this.mResults.putAll(results);
        }

        @Override
        public void writeStartTiming(String label) {
        }

        @Override
        public void writeStopTiming(Bundle results) {
            int i = 0;
            for (Parcelable p : results.getParcelableArrayList("iterations")) {
                Bundle iteration = (Bundle)p;
                String index = "iteration" + i + ".";
                this.mTestResult.putString(index + "label", iteration.getString("label"));
                this.mTestResult.putLong(index + "cpu_time", iteration.getLong("cpu_time"));
                this.mTestResult.putLong(index + "execution_time", iteration.getLong("execution_time"));
                ++i;
            }
        }

        @Override
        public void writeMeasurement(String label, long value) {
            this.mTestResult.putLong(label, value);
        }

        @Override
        public void writeMeasurement(String label, float value) {
            this.mTestResult.putFloat(label, value);
        }

        @Override
        public void writeMeasurement(String label, String value) {
            this.mTestResult.putString(label, value);
        }
    }

    private class SuiteAssignmentPrinter
    implements TestListener {
        private Bundle mTestResult;
        private long mStartTime;
        private long mEndTime;
        private boolean mTimingValid;

        public void startTest(Test test) {
            this.mTimingValid = true;
            this.mStartTime = System.currentTimeMillis();
        }

        public void addError(Test test, Throwable t) {
            this.mTimingValid = false;
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mTimingValid = false;
        }

        public void endTest(Test test) {
            float runTime;
            String assignmentSuite;
            this.mEndTime = System.currentTimeMillis();
            this.mTestResult = new Bundle();
            if (!this.mTimingValid || this.mStartTime < 0L) {
                assignmentSuite = "NA";
                runTime = -1.0f;
            } else {
                runTime = this.mEndTime - this.mStartTime;
                assignmentSuite = runTime < 100.0f && !InstrumentationTestCase.class.isAssignableFrom(test.getClass()) ? JUnit4InstrumentationTestRunner.SMALL_SUITE : (runTime < 1000.0f ? JUnit4InstrumentationTestRunner.MEDIUM_SUITE : JUnit4InstrumentationTestRunner.LARGE_SUITE);
            }
            this.mStartTime = -1L;
            this.mTestResult.putString("stream", ((Describable)test).getDescription().getClassName() + "#" + ((Describable)test).getDescription().getMethodName() + "\nin " + assignmentSuite + " suite\nrunTime: " + String.valueOf(runTime) + "\n");
            this.mTestResult.putFloat(JUnit4InstrumentationTestRunner.REPORT_KEY_RUN_TIME, runTime);
            this.mTestResult.putString(JUnit4InstrumentationTestRunner.REPORT_KEY_SUITE_ASSIGNMENT, assignmentSuite);
            JUnit4InstrumentationTestRunner.this.sendStatus(0, this.mTestResult);
        }
    }
}

