/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.annotation.TargetApi;
import android.os.Bundle;
import com.uphyca.testing.JUnit4InstrumentationTestRunner;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class JUnit4XMLInstrumentationTestRunner
extends JUnit4InstrumentationTestRunner {
    private Writer mWriter;
    private XmlSerializer mTestSuiteSerializer;
    private long mTestStarted;
    private String mOutFileName;
    private static final String XML_OUT = "xml";
    private static final String OUT_FILE_ARG = "outfile";
    private static final String OUT_FILE_DEFAULT = "test-results.xml";
    private boolean mXml;

    private boolean getBooleanArgument(Bundle arguments, String tag) {
        String tagString = arguments.getString(tag);
        return tagString != null && Boolean.parseBoolean(tagString);
    }

    @Override
    public void onCreate(Bundle arguments) {
        if (arguments != null) {
            this.mXml = this.getBooleanArgument(arguments, XML_OUT);
            if (this.mXml) {
                this.mOutFileName = arguments.getString(OUT_FILE_ARG);
                if (this.mOutFileName == null) {
                    this.mOutFileName = OUT_FILE_DEFAULT;
                }
            }
        }
        super.onCreate(arguments);
    }

    @Override
    @TargetApi(value=8)
    public void onStart() {
        if (this.mXml) {
            try {
                File dir = this.getTargetContext().getExternalFilesDir(null);
                if (dir == null) {
                    dir = this.getTargetContext().getFilesDir();
                }
                File outFile = new File(dir, this.mOutFileName);
                this.startJUnitOutput(new FileWriter(outFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.onStart();
    }

    void startJUnitOutput(Writer writer) {
        try {
            this.mWriter = writer;
            this.mTestSuiteSerializer = this.newSerializer(this.mWriter);
            this.mTestSuiteSerializer.startDocument(null, null);
            this.mTestSuiteSerializer.startTag(null, "testsuites");
            this.mTestSuiteSerializer.startTag(null, "testsuite");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XmlSerializer newSerializer(Writer writer) {
        try {
            XmlPullParserFactory pf = XmlPullParserFactory.newInstance();
            XmlSerializer serializer = pf.newSerializer();
            serializer.setOutput(writer);
            return serializer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendStatus(int resultCode, Bundle results) {
        super.sendStatus(resultCode, results);
        if (!this.mXml) {
            return;
        }
        switch (resultCode) {
            case -2: 
            case -1: 
            case 0: {
                try {
                    this.recordTestResult(resultCode, results);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 1: {
                this.recordTestStart(results);
            }
        }
    }

    void recordTestStart(Bundle results) {
        this.mTestStarted = System.currentTimeMillis();
    }

    void recordTestResult(int resultCode, Bundle results) throws IOException {
        float time = (float)(System.currentTimeMillis() - this.mTestStarted) / 1000.0f;
        String className = results.getString("class");
        String testMethod = results.getString("test");
        String stack = results.getString("stack");
        int current = results.getInt("current");
        int total = results.getInt("numtests");
        this.mTestSuiteSerializer.startTag(null, "testcase");
        this.mTestSuiteSerializer.attribute(null, "classname", className);
        this.mTestSuiteSerializer.attribute(null, "name", testMethod);
        if (resultCode != 0) {
            this.mTestSuiteSerializer.startTag(null, "failure");
            if (stack != null) {
                String reason = stack.substring(0, stack.indexOf(10));
                String message = "";
                int index = reason.indexOf(58);
                if (index > -1) {
                    message = reason.substring(index + 1);
                    reason = reason.substring(0, index);
                }
                this.mTestSuiteSerializer.attribute(null, "message", message);
                this.mTestSuiteSerializer.attribute(null, "type", reason);
                this.mTestSuiteSerializer.text(stack);
            }
            this.mTestSuiteSerializer.endTag(null, "failure");
        } else {
            this.mTestSuiteSerializer.attribute(null, "time", String.format("%.3f", Float.valueOf(time)));
        }
        this.mTestSuiteSerializer.endTag(null, "testcase");
        if (current == total) {
            this.mTestSuiteSerializer.startTag(null, "system-out");
            this.mTestSuiteSerializer.endTag(null, "system-out");
            this.mTestSuiteSerializer.startTag(null, "system-err");
            this.mTestSuiteSerializer.endTag(null, "system-err");
            this.mTestSuiteSerializer.endTag(null, "testsuite");
            this.mTestSuiteSerializer.flush();
        }
    }

    public void finish(int resultCode, Bundle results) {
        if (this.mXml) {
            this.endTestSuites();
        }
        super.finish(resultCode, results);
    }

    void endTestSuites() {
        try {
            if (this.mTestSuiteSerializer != null) {
                this.mTestSuiteSerializer.endTag(null, "testsuites");
                this.mTestSuiteSerializer.endDocument();
                this.mTestSuiteSerializer.flush();
            }
            if (this.mWriter != null) {
                this.mWriter.flush();
                this.mWriter.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

