/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing;

import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.IBinder;
import android.test.AndroidTestCase;
import com.uphyca.testing.AndroidTestCaseMethodInvoker;
import com.uphyca.testing.ServiceTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class ServiceTestCase<T extends Service> {
    private final ServiceTester<T> _tester;

    public ServiceTestCase(Class<T> serviceClass) {
        this._tester = new ServiceTester<T>(this, serviceClass);
    }

    @Before
    public void setUp() throws Exception {
        this._tester.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this._tester.tearDown();
    }

    @Test
    public void testAndroidTestCaseSetupProperly() {
        this._tester.testAndroidTestCaseSetupProperly();
    }

    @Test
    public void testServiceTestCaseSetUpProperly() throws Exception {
        this._tester.testServiceTestCaseSetUpProperly();
    }

    public void setContext(Context context) {
        this._tester.setContext(context);
    }

    public Context getContext() {
        return this._tester.getContext();
    }

    public void assertActivityRequiresPermission(String packageName, String className, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertActivityRequiresPermission((AndroidTestCase)((Object)this._tester), packageName, className, permission);
    }

    public void assertReadingContentUriRequiresPermission(Uri uri, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertReadingContentUriRequiresPermission((AndroidTestCase)((Object)this._tester), uri, permission);
    }

    public void assertWritingContentUriRequiresPermission(Uri uri, String permission) {
        AndroidTestCaseMethodInvoker invoker = AndroidTestCaseMethodInvoker.getInstance();
        invoker.assertWritingContentUriRequiresPermission((AndroidTestCase)((Object)this._tester), uri, permission);
    }

    public T getService() {
        return (T)this._tester.getService();
    }

    public void setApplication(Application application) {
        this._tester.setApplication(application);
    }

    public Application getApplication() {
        return this._tester.getApplication();
    }

    public Context getSystemContext() {
        return this._tester.getSystemContext();
    }

    public IBinder bindService(Intent intent) {
        return this._tester.bindService(intent);
    }

    protected void setupService() {
        this._tester.setupService();
    }

    protected void shutdownService() {
        this._tester.shutdownService();
    }

    protected void startService(Intent intent) {
        this._tester.startService(intent);
    }
}

