/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing.android.suitebuilder;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

abstract class Filters {
    Filters() {
    }

    public static Filter union(final Filter first, final Filter second) {
        if (first == second || first == Filter.ALL) {
            return first;
        }
        if (second == Filter.ALL) {
            return second;
        }
        return new Filter(){

            public boolean shouldRun(Description description) {
                return first.shouldRun(description) || second.shouldRun(description);
            }

            public String describe() {
                return first.describe() + " or " + second.describe();
            }
        };
    }

    public static Filter matchSuiteDescription(final Description desiredDescription) {
        return new Filter(){

            public boolean shouldRun(Description description) {
                if (description.isTest()) {
                    return desiredDescription.getTestClass() == description.getTestClass();
                }
                for (Description each : description.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            public String describe() {
                return String.format("Suite %s", desiredDescription.getClassName());
            }
        };
    }
}

