/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing.android.suitebuilder;

import android.util.Log;
import com.android.internal.util.Predicate;
import com.uphyca.testing.android.ClassPathPackageInfo;
import com.uphyca.testing.android.ClassPathPackageInfoSource;
import com.uphyca.testing.android.PackageInfoSources;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;

public class JUnit4TestGrouping {
    private static final String LOG_TAG = "TestGrouping";
    public static final Comparator<Class<?>> SORT_BY_FULLY_QUALIFIED_NAME = new SortByFullyQualifiedName();
    private SortedSet<Class<?>> testCaseClasses;
    protected String firstIncludedPackage = null;
    private ClassLoader classLoader;

    public JUnit4TestGrouping(Comparator<Class<?>> comparator) {
        this.testCaseClasses = new TreeSet(comparator);
    }

    public SortedSet<Class<?>> getTestCaseClasses() {
        return this.testCaseClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JUnit4TestGrouping other = (JUnit4TestGrouping)o;
        if (!this.testCaseClasses.equals(other.testCaseClasses)) {
            return false;
        }
        return ((Object)this.testCaseClasses.comparator()).equals(other.testCaseClasses.comparator());
    }

    public int hashCode() {
        return this.testCaseClasses.hashCode();
    }

    public JUnit4TestGrouping addPackagesRecursive(String ... packageNames) {
        for (String packageName : packageNames) {
            List<Class<?>> addedClasses = this.testCaseClassesInPackage(packageName);
            if (addedClasses.isEmpty()) {
                Log.w((String)LOG_TAG, (String)("Invalid Package: '" + packageName + "' could not be found or has no tests"));
            }
            this.testCaseClasses.addAll(addedClasses);
            if (this.firstIncludedPackage != null) continue;
            this.firstIncludedPackage = packageName;
        }
        return this;
    }

    public JUnit4TestGrouping removePackagesRecursive(String ... packageNames) {
        for (String packageName : packageNames) {
            this.testCaseClasses.removeAll(this.testCaseClassesInPackage(packageName));
        }
        return this;
    }

    public String getFirstIncludedPackage() {
        return this.firstIncludedPackage;
    }

    private List<Class<?>> testCaseClassesInPackage(String packageName) {
        ClassPathPackageInfoSource source = PackageInfoSources.forClassPath(this.classLoader);
        ClassPathPackageInfo packageInfo = source.getPackageInfo(packageName);
        Set<Class<?>> allClasses = packageInfo.getTopLevelClassesRecursive();
        return this.selectTestClasses(allClasses);
    }

    private void addNestedClasses(Set<Class<?>> allClasses, Set<Class<?>> result) {
        for (Class<?> c : allClasses) {
            this.addNestedClasses(c, result);
        }
    }

    private void addNestedClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> c : clazz.getClasses()) {
            result.add(c);
            this.addNestedClasses(c, result);
        }
    }

    private List<Class<?>> selectTestClasses(Set<Class<?>> allClasses) {
        ArrayList testClasses = new ArrayList();
        for (Class<?> testClass : this.select(allClasses, new TestCasePredicate())) {
            testClasses.add(testClass);
        }
        return testClasses;
    }

    private <T> List<T> select(Collection<T> items, Predicate<T> predicate) {
        ArrayList<T> selectedItems = new ArrayList<T>();
        for (T item : items) {
            if (!predicate.apply(item)) continue;
            selectedItems.add(item);
        }
        return selectedItems;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static class TestCasePredicate
    implements Predicate<Class<?>> {
        private TestCasePredicate() {
        }

        @Override
        public boolean apply(Class<?> aClass) {
            if (TestCase.class.isAssignableFrom(aClass)) {
                int modifiers = aClass.getModifiers();
                return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && this.hasValidConstructor(aClass);
            }
            int modifiers = aClass.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers)) {
                return false;
            }
            if (TestCasePredicate.hasAnnotation(aClass, RunWith.class)) {
                return true;
            }
            if (this.hasSuiteMethod(aClass)) {
                return true;
            }
            return TestCasePredicate.hasAnnotatedMethod(aClass);
        }

        private boolean hasSuiteMethod(Class<?> testClass) {
            try {
                testClass.getMethod("suite", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return true;
        }

        private static boolean hasAnnotation(AnnotatedElement meta, Class<? extends Annotation> annon) {
            return meta.isAnnotationPresent(annon);
        }

        private static boolean hasAnnotatedMethod(Class<?> aClass) {
            try {
                for (Method method : aClass.getMethods()) {
                    if (!TestCasePredicate.hasAnnotation(method, Test.class)) continue;
                    return true;
                }
            }
            catch (Exception ignore) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return false;
        }

        private boolean hasValidConstructor(Class<?> aClass) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = aClass.getConstructors()) {
                Class<?>[] parameterTypes;
                if (!Modifier.isPublic(constructor.getModifiers()) || (parameterTypes = constructor.getParameterTypes()).length != 0 && (parameterTypes.length != 1 || parameterTypes[0] != String.class)) continue;
                return true;
            }
            Log.i((String)JUnit4TestGrouping.LOG_TAG, (String)String.format("TestCase class %s is missing a public constructor with no parameters or a single String parameter - skipping", aClass.getName()));
            return false;
        }
    }

    private static class SortByFullyQualifiedName
    implements Comparator<Class<?>>,
    Serializable {
        private SortByFullyQualifiedName() {
        }

        @Override
        public int compare(Class<?> class1, Class<?> class2) {
            return class1.getName().compareTo(class2.getName());
        }
    }
}

