/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing.android.suitebuilder;

import android.content.Context;
import com.android.internal.util.Predicate;
import com.google.android.collect.Lists;
import com.uphyca.testing.android.suitebuilder.JUnit4TestGrouping;
import com.uphyca.testing.android.suitebuilder.JUnit4TestPredicates;
import com.uphyca.testing.junit.internal.builders.AndroidAllDefaultPossibilitiesBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class JUnit4TestSuiteBuilder {
    private Context context;
    private final JUnit4TestGrouping testGrouping = new JUnit4TestGrouping(JUnit4TestGrouping.SORT_BY_FULLY_QUALIFIED_NAME);
    private final Set<Predicate<Description>> predicates = new HashSet<Predicate<Description>>();
    private String currentClassname;
    private String suiteName;
    private Class<?>[] testSuite;
    private List<Description> descriptions = Lists.newArrayList();

    public JUnit4TestSuiteBuilder(Class<?> clazz) {
        this(clazz.getName(), clazz.getClassLoader());
    }

    public JUnit4TestSuiteBuilder(String name, ClassLoader classLoader) {
        this.suiteName = name;
        this.testGrouping.setClassLoader(classLoader);
        this.addRequirements(JUnit4TestPredicates.REJECT_SUPPRESSED);
    }

    public JUnit4TestSuiteBuilder addTestClassByName(String testClassName, String testMethodName, Context context) {
        Description desc = testMethodName == null ? Description.createSuiteDescription(this.loadTestClass(context, testClassName)) : Description.createTestDescription(this.loadTestClass(context, testClassName), (String)testMethodName);
        this.descriptions.add(desc);
        return this;
    }

    private Class<?> loadTestClass(Context context, String testClassName) {
        try {
            return context.getClassLoader().loadClass(testClassName);
        }
        catch (ClassNotFoundException e) {
            this.runFailed("Could not find test class. Class: " + testClassName);
            return null;
        }
    }

    protected void runFailed(String message) {
        throw new RuntimeException(message);
    }

    public JUnit4TestSuiteBuilder includePackages(String ... packageNames) {
        this.testGrouping.addPackagesRecursive(packageNames);
        return this;
    }

    public JUnit4TestSuiteBuilder excludePackages(String ... packageNames) {
        this.testGrouping.removePackagesRecursive(packageNames);
        return this;
    }

    public JUnit4TestSuiteBuilder addRequirements(List<Predicate<Description>> predicates) {
        this.predicates.addAll(predicates);
        return this;
    }

    public final JUnit4TestSuiteBuilder includeAllPackagesUnderHere() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String callingClassName = null;
        String thisClassName = JUnit4TestSuiteBuilder.class.getName();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement element = stackTraceElements[i];
            if (!thisClassName.equals(element.getClassName()) || !"includeAllPackagesUnderHere".equals(element.getMethodName())) continue;
            callingClassName = stackTraceElements[i + 1].getClassName();
            break;
        }
        String packageName = JUnit4TestSuiteBuilder.parsePackageNameFromClassName(callingClassName);
        return this.includePackages(packageName);
    }

    public JUnit4TestSuiteBuilder named(String newSuiteName) {
        this.suiteName = newSuiteName;
        return this;
    }

    public final Request build() {
        ArrayList<Class> testCaseClasses = Lists.newArrayList();
        Filter filters = null;
        if (this.testSuite != null) {
            for (Class<?> clazz : this.testSuite) {
                testCaseClasses.add(clazz);
            }
        }
        for (Class clazz : this.testGrouping.getTestCaseClasses()) {
            testCaseClasses.add(clazz);
        }
        for (Description description : this.descriptions) {
            testCaseClasses.add(description.getTestClass());
        }
        Request req = this.classes(Computer.serial(), testCaseClasses.toArray(new Class[testCaseClasses.size()]));
        Filter filter = new Filter(){

            public boolean shouldRun(Description description) {
                if (description.isTest()) {
                    return JUnit4TestSuiteBuilder.this.satisfiesAllPredicates(description);
                }
                for (Description each : description.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            public String describe() {
                return "requirements";
            }
        };
        filters = filters == null ? filter : filters.intersect(filter);
        req = req.filterWith(filters);
        return req;
    }

    public Request classes(Computer computer, Class<?> ... classes) {
        try {
            AndroidAllDefaultPossibilitiesBuilder builder = new AndroidAllDefaultPossibilitiesBuilder(true);
            Runner suite = computer.getSuite((RunnerBuilder)builder, (Class[])classes);
            return Request.runner((Runner)suite);
        }
        catch (InitializationError e) {
            throw new RuntimeException("Bug in saff's brain: Suite constructor, called as above, should always complete");
        }
    }

    protected String getSuiteName() {
        return this.suiteName;
    }

    public final JUnit4TestSuiteBuilder addRequirements(Predicate<Description> ... predicates) {
        ArrayList<Predicate<Description>> list = new ArrayList<Predicate<Description>>();
        Collections.addAll(list, predicates);
        return this.addRequirements(list);
    }

    protected JUnit4TestGrouping getTestGrouping() {
        return this.testGrouping;
    }

    private boolean satisfiesAllPredicates(Description test) {
        for (Predicate<Description> predicate : this.predicates) {
            if (predicate.apply(test)) continue;
            return false;
        }
        return true;
    }

    private static String parsePackageNameFromClassName(String className) {
        return className.substring(0, className.lastIndexOf(46));
    }

    public void addTestSuite(Class<?>[] testSuite) {
        this.testSuite = testSuite;
    }
}

