/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.testing.junit.internal.runners;

import android.app.Instrumentation;
import android.content.Context;
import android.os.PerformanceCollector;
import com.uphyca.testing.Infrastructure;
import java.lang.annotation.Annotation;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class AndroidJUnit38ClassRunner
extends Runner
implements Filterable,
Sortable {
    private Test fTest;

    public AndroidJUnit38ClassRunner(Class<?> klass) {
        this((Test)new TestSuite(klass.asSubclass(TestCase.class)));
    }

    public AndroidJUnit38ClassRunner(Test test) {
        this.setTest(test);
    }

    public void run(RunNotifier notifier) {
        AndroidTestResult result = new AndroidTestResult();
        result.addListener(this.createAdaptingListener(notifier));
        this.getTest().run((TestResult)result);
    }

    public TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    public Description getDescription() {
        return this.makeDescription(this.getTest());
    }

    private Description makeDescription(Test test) {
        if (test instanceof TestCase) {
            TestCase tc = (TestCase)test;
            return Description.createTestDescription(tc.getClass(), (String)tc.getName());
        }
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            String name = ts.getName() == null ? AndroidJUnit38ClassRunner.createSuiteDescription(ts) : ts.getName();
            Description description = Description.createSuiteDescription((String)name, (Annotation[])new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                Description made = this.makeDescription(ts.testAt(i));
                description.addChild(made);
            }
            return description;
        }
        if (test instanceof Describable) {
            Describable adapter = (Describable)test;
            return adapter.getDescription();
        }
        if (test instanceof TestDecorator) {
            TestDecorator decorator = (TestDecorator)test;
            return this.makeDescription(decorator.getTest());
        }
        return Description.createSuiteDescription(test.getClass());
    }

    private static String createSuiteDescription(TestSuite ts) {
        int count = ts.countTestCases();
        String example = count == 0 ? "" : String.format(" [example: %s]", ts.testAt(0));
        return String.format("TestSuite with %s tests%s", count, example);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.getTest() instanceof Filterable) {
            Filterable adapter = (Filterable)this.getTest();
            adapter.filter(filter);
        } else if (this.getTest() instanceof TestSuite) {
            TestSuite suite = (TestSuite)this.getTest();
            TestSuite filtered = new TestSuite(suite.getName());
            int n = suite.testCount();
            for (int i = 0; i < n; ++i) {
                Test test = suite.testAt(i);
                if (!filter.shouldRun(this.makeDescription(test))) continue;
                filtered.addTest(test);
            }
            this.setTest((Test)filtered);
        }
    }

    public void sort(Sorter sorter) {
        if (this.getTest() instanceof Sortable) {
            Sortable adapter = (Sortable)this.getTest();
            adapter.sort(sorter);
        }
    }

    private void setTest(Test test) {
        this.fTest = test;
    }

    private Test getTest() {
        return this.fTest;
    }

    private static final class AndroidTestResult
    extends TestResult {
        private final Context fContext = Infrastructure.getContext();
        private final Context fTestContext = Infrastructure.getTestContext();
        private final Instrumentation fInstrumentation = Infrastructure.getInstrumentation();
        private final PerformanceCollector.PerformanceResultsWriter fPerformanceResultsWriter = Infrastructure.getPerformanceResultsWriter();

        protected void run(TestCase test) {
            Infrastructure.setContextIfAndroidTestCase((Test)test, this.fContext, this.fTestContext);
            Infrastructure.setInstrumentationIfInstrumentationTestCase((Test)test, this.fInstrumentation);
            Infrastructure.setPerformanceWriterIfPerformanceCollectorTestCase((Test)test, this.fPerformanceResultsWriter);
            super.run(test);
        }
    }

    private final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void endTest(Test test) {
            this.fNotifier.fireTestFinished(this.asDescription(test));
        }

        public void startTest(Test test) {
            this.fNotifier.fireTestStarted(this.asDescription(test));
        }

        public void addError(Test test, Throwable t) {
            Failure failure = new Failure(this.asDescription(test), t);
            this.fNotifier.fireTestFailure(failure);
        }

        private Description asDescription(Test test) {
            if (test instanceof Describable) {
                Describable facade = (Describable)test;
                return facade.getDescription();
            }
            return Description.createTestDescription(this.getEffectiveClass(test), (String)this.getName(test));
        }

        private Class<? extends Test> getEffectiveClass(Test test) {
            return test.getClass();
        }

        private String getName(Test test) {
            if (test instanceof TestCase) {
                return ((TestCase)test).getName();
            }
            return test.toString();
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.addError(test, (Throwable)t);
        }
    }
}

