/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MinimalSubstitutionMap
implements SubstitutionMap {
    private static final char[] START_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int lastIndex = 0;
    private final char[] startChars;
    private final char[] chars;
    private final int startCharsRadix;
    private final int charsRadix;
    private final double logCharsRadix;
    private final Map<String, String> renamedCssClasses;
    private final Set<String> outputValueBlacklist;

    public MinimalSubstitutionMap() {
        this((Set<String>)ImmutableSet.of());
    }

    public MinimalSubstitutionMap(Set<String> outputValueBlacklist) {
        this(START_CHARS, CHARS, outputValueBlacklist);
    }

    @VisibleForTesting
    MinimalSubstitutionMap(char[] startChars, char[] chars) {
        this(startChars, chars, (Set<String>)ImmutableSet.of());
    }

    @VisibleForTesting
    MinimalSubstitutionMap(char[] startChars, char[] chars, Set<String> outputValueBlacklist) {
        this.startChars = Arrays.copyOf(startChars, startChars.length);
        this.startCharsRadix = this.startChars.length;
        this.chars = Arrays.copyOf(chars, chars.length);
        this.charsRadix = this.chars.length;
        this.logCharsRadix = Math.log(this.charsRadix);
        this.renamedCssClasses = Maps.newHashMap();
        this.outputValueBlacklist = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputValueBlacklist)));
    }

    @Override
    public String get(String key) {
        String value = this.renamedCssClasses.get(key);
        if (value == null) {
            while (this.outputValueBlacklist.contains(value = this.toShortString(this.lastIndex++))) {
            }
            this.renamedCssClasses.put(key, value);
        }
        return value;
    }

    @VisibleForTesting
    String toShortString(int index) {
        int i = index / this.startCharsRadix;
        int n = (int)(Math.log(i * (this.charsRadix - 1) + 1) / this.logCharsRadix);
        char[] cssNameChars = new char[n + 1];
        cssNameChars[0] = this.startChars[index % this.startCharsRadix];
        for (int k = 1; k <= n; ++k) {
            cssNameChars[k] = this.chars[i % this.charsRadix];
            i /= this.charsRadix;
        }
        return new String(cssNameChars);
    }
}

