/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public enum OutputRenamingMapFormat {
    CLOSURE_COMPILED("goog.setCssNameMapping(%s);\n"),
    CLOSURE_COMPILED_BY_WHOLE("goog.setCssNameMapping(%s, 'BY_WHOLE');\n"),
    CLOSURE_COMPILED_SPLIT_HYPHENS{

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
            HashMap newSplitRenamingMap = Maps.newHashMap();
            for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
                Iterator parts = HYPHEN_SPLITTER.split((CharSequence)entry.getKey()).iterator();
                Iterator partsNew = HYPHEN_SPLITTER.split((CharSequence)entry.getValue()).iterator();
                while (parts.hasNext() && partsNew.hasNext()) {
                    newSplitRenamingMap.put(parts.next(), partsNew.next());
                }
                if (parts.hasNext()) {
                    throw new AssertionError((Object)("Not all parts of the original class name were output. Class: " + entry.getKey() + " Next Part:" + (String)parts.next()));
                }
                if (partsNew.hasNext()) {
                    throw new AssertionError((Object)("Not all parts of the renamed class were output. Class: " + entry.getKey() + " Renamed Class: " + entry.getValue() + " Next Part:" + (String)partsNew.next()));
                }
            }
            CLOSURE_COMPILED.writeRenamingMap(newSplitRenamingMap, renamingMapWriter);
        }
    }
    ,
    CLOSURE_UNCOMPILED("CLOSURE_CSS_NAME_MAPPING = %s;\n"),
    JSON,
    PROPERTIES{

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
            for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
                renamingMapWriter.format("%s=%s\n", entry.getKey(), entry.getValue());
            }
        }
    }
    ,
    JSCOMP_VARIABLE_MAP{

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
            for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
                renamingMapWriter.format("%s:%s\n", entry.getKey(), entry.getValue());
            }
        }
    };

    private static final Splitter HYPHEN_SPLITTER;
    private final String formatString;

    private OutputRenamingMapFormat(String formatString) {
        Preconditions.checkNotNull((Object)formatString);
        this.formatString = formatString;
    }

    private OutputRenamingMapFormat() {
        this("%s");
    }

    public void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
        JsonObject properties = new JsonObject();
        for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
            properties.addProperty(entry.getKey(), entry.getValue());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        renamingMapWriter.write(String.format(this.formatString, gson.toJson((JsonElement)properties)));
    }

    static {
        HYPHEN_SPLITTER = Splitter.on((String)"-");
    }
}

