/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.ast;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CssCompositeValueNode
extends CssValueNode {
    private List<CssValueNode> values;
    private Operator operator;

    public CssCompositeValueNode(List<CssValueNode> compositeValues, Operator operator, @Nullable SourceCodeLocation sourceCodeLocation) {
        super((String)null, sourceCodeLocation);
        this.operator = operator;
        this.values = Lists.newArrayList(compositeValues);
        this.becomeParentForNodes(this.values);
    }

    public CssCompositeValueNode(CssCompositeValueNode node) {
        this(CssCompositeValueNode.deepCopyCompositeValues(node.getValues()), node.getOperator(), node.getSourceCodeLocation());
    }

    private static List<CssValueNode> deepCopyCompositeValues(List<CssValueNode> compositeValues) {
        ArrayList copy = Lists.newArrayList();
        for (CssValueNode child : compositeValues) {
            copy.add(child.deepCopy());
        }
        return copy;
    }

    @Override
    public CssCompositeValueNode deepCopy() {
        return new CssCompositeValueNode(this);
    }

    public List<CssValueNode> getValues() {
        return this.values;
    }

    public void addValue(CssValueNode value) {
        this.values.add(value);
        this.becomeParentForNode(value);
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return Joiner.on((String)this.operator.getOperatorName()).join(this.values);
    }

    public static enum Operator {
        SPACE(" "),
        COMMA(","),
        SLASH("/"),
        EQUALS("="),
        UNKNOWN(null);

        private final String operatorName;

        private Operator(String operatorName) {
            this.operatorName = operatorName;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public static Operator valueOf(char c) {
            switch (c) {
                case ',': {
                    return COMMA;
                }
                case '/': {
                    return SLASH;
                }
                case '=': {
                    return EQUALS;
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.getOperatorName();
        }
    }
}

