/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssIdSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;

public class CssClassRenaming
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final SubstitutionMap cssClassRenamingMap;
    private final SubstitutionMap elementIdMap;

    public CssClassRenaming(MutatingVisitController visitController, SubstitutionMap cssClassRenamingMap, SubstitutionMap elementIdMap) {
        this.visitController = visitController;
        this.cssClassRenamingMap = cssClassRenamingMap;
        this.elementIdMap = elementIdMap;
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        if (this.cssClassRenamingMap == null) {
            return true;
        }
        String substitution = this.cssClassRenamingMap.get(node.getRefinerName());
        if (substitution == null) {
            return true;
        }
        CssClassSelectorNode classSelector = new CssClassSelectorNode(substitution, node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)classSelector), false);
        return true;
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        if (this.elementIdMap == null) {
            return true;
        }
        String substitution = this.elementIdMap.get(node.getRefinerName());
        if (substitution == null) {
            return true;
        }
        CssIdSelectorNode idSelector = new CssIdSelectorNode(substitution, node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)idSelector), false);
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

